function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits } from '../../../global_styling';
import { euiFormVariables } from '../form.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "3lf9c4-euiFormControlLayoutIcons",
  styles: "pointer-events:none;display:flex;align-items:center;label:euiFormControlLayoutIcons;"
} : {
  name: "3lf9c4-euiFormControlLayoutIcons",
  styles: "pointer-events:none;display:flex;align-items:center;label:euiFormControlLayoutIcons;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiFormControlLayoutIconsStyles = function euiFormControlLayoutIconsStyles(euiThemeContext) {
  var _euiFormVariables = euiFormVariables(euiThemeContext),
    controlPadding = _euiFormVariables.controlPadding,
    controlCompressedPadding = _euiFormVariables.controlCompressedPadding,
    controlDisabledColor = _euiFormVariables.controlDisabledColor;
  return {
    euiFormControlLayoutIcons: _ref,
    uncompressed: "\n      gap: ".concat(mathWithUnits(controlPadding, function (x) {
      return x / 2;
    }), ";\n    "),
    compressed: /*#__PURE__*/css("gap:", mathWithUnits(controlCompressedPadding, function (x) {
      return x / 2;
    }), ";;label:compressed;"),
    disabled: /*#__PURE__*/css("cursor:not-allowed;color:", controlDisabledColor, ";;label:disabled;"),
    position: {
      absolute: {
        absolute: /*#__PURE__*/css("position:absolute;", logicalCSS('vertical', 0), ";;label:absolute;"),
        uncompressed: {
          left: /*#__PURE__*/css("z-index:1;", logicalCSS('left', controlPadding), ";;label:left;"),
          right: /*#__PURE__*/css(logicalCSS('right', controlPadding), ";;label:right;")
        },
        compressed: {
          left: /*#__PURE__*/css("z-index:1;", logicalCSS('left', controlCompressedPadding), ";;label:left;"),
          right: /*#__PURE__*/css(logicalCSS('right', controlCompressedPadding), ";;label:right;")
        }
      },
      static: {
        static: /*#__PURE__*/css("position:static;", logicalCSS('height', '100%'), " align-self:stretch;flex-grow:0;", logicalCSS('padding-horizontal', '100%'), ";;label:static;"),
        uncompressed: logicalCSS('padding-horizontal', controlPadding),
        compressed: logicalCSS('padding-horizontal', controlCompressedPadding)
      }
    }
  };
};