import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "children", "helpText", "isInvalid", "error", "label", "labelType", "labelAppend", "hasEmptyLabelSpace", "fullWidth", "describedByIds", "display", "hasChildLabel", "id", "isDisabled"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { cloneElement, Children, useState, useCallback, useMemo } from 'react';
import classNames from 'classnames';
import { useGeneratedHtmlId, useEuiMemoizedStyles } from '../../../services';
import { EuiSpacer } from '../../spacer';
import { EuiFormHelpText } from '../form_help_text';
import { EuiFormErrorText } from '../form_error_text';
import { EuiFormLabel } from '../form_label';
import { useFormContext } from '../eui_form_context';
import { euiFormRowStyles } from './form_row.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var DISPLAYS = ['row', 'columnCompressed', 'center', 'centerCompressed',
/**
 * This currently does not affect styles/appearances
 * in EUI's present primary theme, but may in the future.
 */
'rowCompressed'];
export var EuiFormRow = function EuiFormRow(_ref) {
  var className = _ref.className,
    children = _ref.children,
    helpText = _ref.helpText,
    isInvalid = _ref.isInvalid,
    error = _ref.error,
    label = _ref.label,
    _ref$labelType = _ref.labelType,
    labelType = _ref$labelType === void 0 ? 'label' : _ref$labelType,
    labelAppend = _ref.labelAppend,
    _ref$hasEmptyLabelSpa = _ref.hasEmptyLabelSpace,
    hasEmptyLabelSpace = _ref$hasEmptyLabelSpa === void 0 ? false : _ref$hasEmptyLabelSpa,
    _fullWidth = _ref.fullWidth,
    describedByIds = _ref.describedByIds,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'row' : _ref$display,
    _ref$hasChildLabel = _ref.hasChildLabel,
    hasChildLabel = _ref$hasChildLabel === void 0 ? true : _ref$hasChildLabel,
    propsId = _ref.id,
    isDisabled = _ref.isDisabled,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useFormContext = useFormContext(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var fullWidth = _fullWidth !== null && _fullWidth !== void 0 ? _fullWidth : defaultFullWidth;
  var id = useGeneratedHtmlId({
    conditionalId: propsId
  });
  var hasLabel = label || labelAppend;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isFocused = _useState2[0],
    setIsFocused = _useState2[1];
  var onFocusWithin = useCallback(function () {
    return setIsFocused(true);
  }, []);
  var onBlurWithin = useCallback(function () {
    return setIsFocused(false);
  }, []);
  var classes = classNames('euiFormRow', {
    'euiFormRow--hasEmptyLabelSpace': hasEmptyLabelSpace,
    'euiFormRow--hasLabel': hasLabel
  }, className);
  var styles = useEuiMemoizedStyles(euiFormRowStyles);
  var cssStyles = [styles.euiFormRow, fullWidth ? styles.fullWidth : styles.formWidth, styles[display]];
  var optionalHelpTexts = useMemo(function () {
    if (!helpText) return;
    var helpTexts = Array.isArray(helpText) ? helpText : [helpText];
    return helpTexts.map(function (helpText, i) {
      var key = typeof helpText === 'string' ? helpText : i;
      return ___EmotionJSX(EuiFormHelpText, {
        key: key,
        id: "".concat(id, "-help-").concat(i),
        className: "euiFormRow__text"
      }, helpText);
    });
  }, [helpText, id]);
  var optionalErrors = useMemo(function () {
    if (!(error && isInvalid)) return;
    var errorTexts = Array.isArray(error) ? error : [error];
    return errorTexts.map(function (error, i) {
      var key = typeof error === 'string' ? error : i;
      return ___EmotionJSX(EuiFormErrorText, {
        key: key,
        id: "".concat(id, "-error-").concat(i),
        className: "euiFormRow__text"
      }, error);
    });
  }, [error, isInvalid, id]);
  var ariaDescribedBy = useMemo(function () {
    var describingIds = _toConsumableArray(describedByIds || []);
    if (optionalHelpTexts !== null && optionalHelpTexts !== void 0 && optionalHelpTexts.length) {
      optionalHelpTexts.forEach(function (optionalHelpText) {
        return describingIds.push(optionalHelpText.props.id);
      });
    }
    if (optionalErrors !== null && optionalErrors !== void 0 && optionalErrors.length) {
      optionalErrors.forEach(function (error) {
        return describingIds.push(error.props.id);
      });
    }
    if (describingIds.length) {
      return describingIds.join(' ');
    }
  }, [describedByIds, optionalHelpTexts, optionalErrors]);
  var field = useMemo(function () {
    var _ref2, _child$props$disabled;
    var child = Children.only(children);
    return /*#__PURE__*/cloneElement(child, {
      id: id,
      // Allow the child's disabled or isDisabled prop to supercede the `isDisabled`
      disabled: (_ref2 = (_child$props$disabled = child.props.disabled) !== null && _child$props$disabled !== void 0 ? _child$props$disabled : child.props.isDisabled) !== null && _ref2 !== void 0 ? _ref2 : isDisabled,
      'aria-describedby': ariaDescribedBy
    });
  }, [children, id, isDisabled, ariaDescribedBy]);
  var Element = labelType === 'legend' ? 'fieldset' : 'div';
  return ___EmotionJSX(Element, _extends({
    css: cssStyles,
    className: classes,
    id: "".concat(id, "-row")
  }, rest), hasLabel ? ___EmotionJSX("div", {
    className: "euiFormRow__labelWrapper"
  }, ___EmotionJSX(EuiFormLabel, _extends({
    className: "euiFormRow__label",
    "aria-invalid": isInvalid,
    isInvalid: isInvalid,
    isDisabled: isDisabled,
    isFocused: isFocused && !isDisabled,
    id: "".concat(id, "-label")
    // ExclusiveUnion shenanigans
  }, labelType === 'legend' ? {
    type: labelType
  } : {
    type: labelType,
    htmlFor: hasChildLabel ? id : undefined
  }), label), labelAppend && ' ', labelAppend) : hasEmptyLabelSpace && ___EmotionJSX(EuiSpacer, {
    size: "m",
    className: "euiFormRow__labelWrapper"
  }), ___EmotionJSX("div", {
    className: "euiFormRow__fieldWrapper",
    onFocus: onFocusWithin,
    onBlur: onBlurWithin
  }, field, optionalErrors, optionalHelpTexts));
};