import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "id", "name", "checked", "label", "value", "onChange", "disabled", "autoFocus", "labelProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiIcon } from '../../icon';
import { euiRadioStyles } from './radio.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRadio = function EuiRadio(_ref) {
  var className = _ref.className,
    id = _ref.id,
    name = _ref.name,
    checked = _ref.checked,
    label = _ref.label,
    value = _ref.value,
    onChange = _ref.onChange,
    disabled = _ref.disabled,
    autoFocus = _ref.autoFocus,
    labelProps = _ref.labelProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiRadio', className);
  var styles = useEuiMemoizedStyles(euiRadioStyles);
  var inputStyles = [styles.input.euiRadio__circle, !!label && styles.input.hasLabel, disabled ? checked ? styles.input.disabled.selected : styles.input.disabled.unselected : checked ? styles.input.enabled.selected : styles.input.enabled.unselected];
  var labelClasses = classNames('euiRadio__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  var labelStyles = [styles.label.euiRadio__label, disabled ? styles.label.disabled : styles.label.enabled, labelProps === null || labelProps === void 0 ? void 0 : labelProps.css];
  return ___EmotionJSX("div", _extends({
    css: styles.euiRadio,
    className: classes
  }, rest), ___EmotionJSX("div", {
    css: inputStyles,
    className: "euiRadio__circle"
  }, ___EmotionJSX(EuiIcon, {
    css: styles.input.euiRadio__icon,
    type: "dot"
  }), ___EmotionJSX("input", {
    css: styles.input.euiRadio__input,
    className: "euiRadio__input",
    type: "radio",
    id: id,
    name: name,
    value: value,
    checked: checked,
    onChange: onChange,
    disabled: disabled,
    autoFocus: autoFocus
  })), label && ___EmotionJSX("label", _extends({}, labelProps, {
    css: labelStyles,
    className: labelClasses,
    htmlFor: id
  }), label));
};