/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFormCustomControlStyles } from '../form.styles';
export var euiRadioStyles = function euiRadioStyles(euiThemeContext) {
  var controlStyles = euiFormCustomControlStyles(euiThemeContext);
  return {
    euiRadio: /*#__PURE__*/css(controlStyles.wrapper, ";label:euiRadio;"),
    input: {
      euiRadio__circle: /*#__PURE__*/css(controlStyles.input.fauxInput, " border-radius:50%;;label:euiRadio__circle;"),
      hasLabel: controlStyles.input.hasLabel,
      // Skip css`` className generation
      enabled: {
        selected: /*#__PURE__*/css(controlStyles.input.enabled.selected, ";label:selected;"),
        unselected: /*#__PURE__*/css(controlStyles.input.enabled.unselected, ";label:unselected;")
      },
      disabled: {
        selected: /*#__PURE__*/css(controlStyles.input.disabled.selected, ";label:selected;"),
        unselected: /*#__PURE__*/css(controlStyles.input.disabled.unselected, ";label:unselected;")
      },
      euiRadio__icon: /*#__PURE__*/css(controlStyles.input.icon, ";label:euiRadio__icon;"),
      euiRadio__input: /*#__PURE__*/css(controlStyles.input.hiddenInput, ";label:euiRadio__input;")
    },
    label: {
      euiRadio__label: /*#__PURE__*/css(controlStyles.label.label, ";label:euiRadio__label;"),
      enabled: controlStyles.label.enabled,
      disabled: /*#__PURE__*/css(controlStyles.label.disabled, ";label:disabled;")
    }
  };
};