import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />

import React, { useState } from 'react';
import { EuiRadioGroup } from './radio_group';
import { jsx as ___EmotionJSX } from "@emotion/react";
var RadioGroup = function RadioGroup() {
  var radioGroupItemId__1 = 'cy-radio-id-1';
  var radioGroupItemId__2 = 'cy-radio-id-2';
  var radioGroupItemId__3 = 'cy-radio-id-3';
  var radioGroupItemId__4 = 'cy-radio-id-4';
  var radios = [{
    id: radioGroupItemId__1,
    label: 'Option one'
  }, {
    id: radioGroupItemId__2,
    label: 'Option two'
  }, {
    id: radioGroupItemId__3,
    label: 'Option three is disabled',
    disabled: true
  }, {
    id: radioGroupItemId__4,
    label: 'Option four'
  }];
  var _useState = useState(radioGroupItemId__1),
    _useState2 = _slicedToArray(_useState, 2),
    radioIdSelected = _useState2[0],
    setRadioIdSelected = _useState2[1];
  return ___EmotionJSX(EuiRadioGroup, {
    options: radios,
    idSelected: radioIdSelected,
    onChange: function onChange(id) {
      return setRadioIdSelected(id);
    },
    name: "radio group",
    legend: {
      children: ___EmotionJSX("span", null, "This is a legend for a radio group")
    }
  });
};
describe('EuiRadioGroup', function () {
  beforeEach(function () {
    cy.realMount(___EmotionJSX(RadioGroup, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('has zero violations after traversing radio group', function () {
      cy.realPress('Tab');
      cy.get('#cy-radio-id-1').should('have.focus');
      cy.realPress('Space');
      cy.get('#cy-radio-id-1').should('be.checked');
      cy.realPress('ArrowDown');
      cy.get('#cy-radio-id-2').should('be.checked');
      cy.realPress('ArrowRight');
      cy.get('#cy-radio-id-3').should('not.be.checked');
      cy.get('#cy-radio-id-4').should('be.checked');
      cy.checkAxe();
    });
  });
  describe('Disabled radio button accessibility', function () {
    it('affects no change after clicking the disabled radio button', function () {
      cy.get('#cy-radio-id-3').realClick();
      cy.get('#cy-radio-id-3').should('not.be.checked');
      cy.checkAxe();
    });
  });
});