import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["className", "css", "compressed", "disabled", "fullWidth", "isLoading", "readOnly", "id", "max", "min", "name", "step", "showLabels", "showInput", "showTicks", "tickInterval", "ticks", "levels", "onBlur", "onChange", "onFocus", "showRange", "value", "isInvalid", "append", "prepend", "minInputProps", "maxInputProps", "inputPopoverProps", "isDraggable", "theme"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import { keys, htmlIdGenerator, withEuiTheme } from '../../../services';
import { isWithinRange } from '../../../services/number';
import { logicalStyles } from '../../../global_styling';
import { EuiInputPopover } from '../../popover';
import { EuiFormControlLayoutDelimited } from '../form_control_layout';
import { FormContext } from '../eui_form_context';
import { EuiRangeDraggable } from './range_draggable';
import { EuiRangeHighlight } from './range_highlight';
import { EuiRangeInput } from './range_input';
import { EuiRangeLabel } from './range_label';
import { getLevelColor, euiRangeLevelColor } from './range_levels_colors';
import { EuiRangeSlider } from './range_slider';
import { EuiRangeThumb } from './range_thumb';
import { EuiRangeTrack } from './range_track';
import { EuiRangeWrapper } from './range_wrapper';
import { calculateThumbPosition } from './utils';
import { euiRangeStyles } from './range.styles';
import { euiDualRangeStyles } from './dual_range.styles';
import { EuiI18n } from '../../i18n';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDualRangeClass = /*#__PURE__*/function (_Component) {
  function EuiDualRangeClass() {
    var _this;
    _classCallCheck(this, EuiDualRangeClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiDualRangeClass, [].concat(args));
    _defineProperty(_this, "state", {
      id: _this.props.id || htmlIdGenerator()(),
      isPopoverOpen: false,
      rangeWidth: 0
    });
    _defineProperty(_this, "preventPopoverClose", false);
    _defineProperty(_this, "leftPosition", 0);
    _defineProperty(_this, "dragAcc", 0);
    _defineProperty(_this, "_determineInvalidThumbMovement", function (newVal, lower, upper, e) {
      // If the values are invalid, find whether the new value is in the upper
      // or lower half and move the appropriate handle to the new value,
      // while the other handle gets moved to the opposite bound (if invalid)
      var min = _this.props.min;
      var max = _this.props.max;
      var lowerHalf = Math.abs(max - min) / 2 + min;
      var newValIsLow = isWithinRange(min, lowerHalf, newVal);
      if (newValIsLow) {
        lower = newVal;
        upper = !_this.upperValueIsValid ? max : upper;
      } else {
        lower = !_this.lowerValueIsValid ? min : lower;
        upper = newVal;
      }
      _this._handleOnChange(lower, upper, e);
    });
    _defineProperty(_this, "_determineValidThumbMovement", function (newVal, lower, upper, e) {
      // Lower thumb targeted or right-moving swap has occurred
      if (Math.abs(lower - newVal) < Math.abs(upper - newVal)) {
        lower = newVal;
      }
      // Upper thumb targeted or left-moving swap has occurred
      else {
        upper = newVal;
      }
      _this._handleOnChange(lower, upper, e);
    });
    _defineProperty(_this, "_determineThumbMovement", function (newVal, e) {
      // Determine thumb movement based on slider interaction
      if (!_this.isValid) {
        // Non-standard positioning follows
        _this._determineInvalidThumbMovement(newVal, _this.lowerValue, _this.upperValue, e);
      } else {
        // Standard positioning based on click event proximity to thumb locations
        _this._determineValidThumbMovement(newVal, _this.lowerValue, _this.upperValue, e);
      }
    });
    _defineProperty(_this, "_handleOnChange", function (lower, upper, e) {
      var isValid = isWithinRange(_this.props.min, upper, lower) && isWithinRange(lower, _this.props.max, upper);
      _this.props.onChange([lower, upper], isValid, e);
    });
    _defineProperty(_this, "handleSliderChange", function (e) {
      _this._determineThumbMovement(Number(e.currentTarget.value), e);
    });
    _defineProperty(_this, "_resetToRangeEnds", function (e) {
      // Arbitrary decision to pass `min` instead of `max`. Result is the same.
      _this._determineInvalidThumbMovement(_this.props.min, _this.lowerValue, _this.upperValue, e);
    });
    _defineProperty(_this, "_isDirectionalKeyPress", function (event) {
      return [keys.ARROW_UP, keys.ARROW_RIGHT, keys.ARROW_DOWN, keys.ARROW_LEFT].indexOf(event.key) > -1;
    });
    _defineProperty(_this, "handleInputKeyDown", function (e) {
      // Relevant only when initial values are both `''` and `showInput` is set
      if (_this._isDirectionalKeyPress(e) && !_this.isValid) {
        e.preventDefault();
        _this._resetToRangeEnds(e);
      }
    });
    _defineProperty(_this, "handleLowerInputChange", function (e) {
      _this._handleOnChange(e.target.value, _this.upperValue, e);
    });
    _defineProperty(_this, "handleUpperInputChange", function (e) {
      _this._handleOnChange(_this.lowerValue, e.target.value, e);
    });
    _defineProperty(_this, "_handleKeyDown", function (value, event) {
      var newVal = Number(value);
      var stepRemainder = 0;
      var step = _this.props.step || 1;
      var min = _this.props.min;
      switch (event.key) {
        case keys.ARROW_UP:
        case keys.ARROW_RIGHT:
          event.preventDefault();
          newVal += step;
          stepRemainder = (newVal - min) % step;
          if (step !== 1 && stepRemainder > 0) {
            newVal = newVal - stepRemainder;
          }
          break;
        case keys.ARROW_DOWN:
        case keys.ARROW_LEFT:
          event.preventDefault();
          newVal -= step;
          stepRemainder = (newVal - min) % step;
          if (step !== 1 && stepRemainder > 0) {
            newVal = newVal + (step - stepRemainder);
          }
          break;
      }
      return newVal;
    });
    _defineProperty(_this, "handleLowerKeyDown", function (event) {
      var lower = _this.lowerValue;
      switch (event.key) {
        case keys.TAB:
          return;
        default:
          if (!_this.lowerValueIsValid) {
            // Relevant only when initial value is `''` and `showInput` is not set
            event.preventDefault();
            _this._resetToRangeEnds(event);
            return;
          }
          lower = _this._handleKeyDown(lower, event);
      }
      if (lower >= Number(_this.upperValue) || lower < _this.props.min) return;
      _this._handleOnChange(lower, _this.upperValue, event);
    });
    _defineProperty(_this, "handleUpperKeyDown", function (event) {
      var upper = _this.upperValue;
      switch (event.key) {
        case keys.TAB:
          return;
        default:
          if (!_this.upperValueIsValid) {
            // Relevant only when initial value is `''` and `showInput` is not set
            event.preventDefault();
            _this._resetToRangeEnds(event);
            return;
          }
          upper = _this._handleKeyDown(upper, event);
      }
      if (upper <= Number(_this.lowerValue) || upper > _this.props.max) return;
      _this._handleOnChange(_this.lowerValue, upper, event);
    });
    _defineProperty(_this, "handleDraggableKeyDown", function (event) {
      var lower = _this.lowerValue;
      var upper = _this.upperValue;
      switch (event.key) {
        case keys.TAB:
          return;
        default:
          lower = _this._handleKeyDown(lower, event);
          upper = _this._handleKeyDown(upper, event);
      }
      if (lower >= Number(_this.upperValue) || lower < _this.props.min) return;
      if (upper <= Number(_this.lowerValue) || upper > _this.props.max) return;
      _this._handleOnChange(lower, upper, event);
    });
    _defineProperty(_this, "calculateThumbPositionStyle", function (value, width) {
      var trackWidth = _this.isInPopover && !!width ? width : _this.state.rangeWidth;
      var position = calculateThumbPosition(value, _this.props.min, _this.props.max, trackWidth);
      return {
        left: "".concat(position, "%")
      };
    });
    _defineProperty(_this, "onThumbFocus", function (e) {
      if (_this.props.onFocus) {
        _this.props.onFocus(e);
      }
    });
    _defineProperty(_this, "onThumbBlur", function (e) {
      if (_this.props.onBlur) {
        _this.props.onBlur(e);
      }
    });
    _defineProperty(_this, "onInputFocus", function (e) {
      if (_this.props.onFocus) {
        _this.props.onFocus(e);
      }
      _this.preventPopoverClose = true;
      _this.setState({
        isPopoverOpen: true
      });
    });
    _defineProperty(_this, "onInputBlur", function (e) {
      return setTimeout(function () {
        // Safari does not recognize any focus-related eventing for input[type=range]
        // making it impossible to capture its state using active/focus/relatedTarget
        // Instead, a prevention flag is set on mousedown, with a waiting period here.
        // Mousedown is viable because in the popover case, it is inaccessible via keyboard (intentionally)
        if (_this.preventPopoverClose) {
          _this.preventPopoverClose = false;
          return;
        }
        if (_this.props.onBlur) {
          _this.props.onBlur(e);
        }
        _this.closePopover();
      }, 200);
    });
    _defineProperty(_this, "closePopover", function () {
      _this.preventPopoverClose = false;
      _this.setState({
        isPopoverOpen: false
      });
    });
    _defineProperty(_this, "setRangeWidth", function (_ref) {
      var width = _ref.width;
      _this.setState({
        rangeWidth: width
      });
    });
    _defineProperty(_this, "getNearestStep", function (value) {
      var min = _this.props.min;
      var max = _this.props.max;
      var steps = (_this.props.max - _this.props.min) / _this.props.step;
      var approx = Math.round((value - min) * steps / (max - min)) / steps;
      var bound = Math.min(Math.max(approx, 0), 1);
      var nearest = bound * (max - min) + min;
      return Number(nearest.toPrecision(10)) * 100 / 100;
    });
    _defineProperty(_this, "handleDrag", function (x, isFirstInteraction) {
      if (isFirstInteraction) {
        _this.leftPosition = x;
        _this.dragAcc = 0;
      }
      var min = _this.props.min;
      var max = _this.props.max;
      var lowerValue = Number(_this.lowerValue);
      var upperValue = Number(_this.upperValue);
      var delta = _this.leftPosition - x;
      _this.leftPosition = x;
      _this.dragAcc = _this.dragAcc + delta;
      var percentageOfArea = _this.dragAcc / _this.state.rangeWidth;
      var percentageOfRange = percentageOfArea * (max - min);
      var newLower = _this.getNearestStep(lowerValue - percentageOfRange);
      var newUpper = _this.getNearestStep(upperValue - percentageOfRange);
      var noMovement = newLower === lowerValue;
      var isMin = min === lowerValue && min === newLower;
      var isMax = max === upperValue && max === newUpper;
      var isOutOfRange = newLower < min || newUpper > max;
      if (noMovement || isMin || isMax || isOutOfRange) return;
      _this._handleOnChange(newLower, newUpper);
      _this.dragAcc = 0;
    });
    return _this;
  }
  _inherits(EuiDualRangeClass, _Component);
  return _createClass(EuiDualRangeClass, [{
    key: "isInPopover",
    get: function get() {
      return this.props.showInput === 'inputWithPopover';
    }
  }, {
    key: "lowerValue",
    get: function get() {
      return this.props.value ? this.props.value[0] : this.props.min;
    }
  }, {
    key: "upperValue",
    get: function get() {
      return this.props.value ? this.props.value[1] : this.props.max;
    }
  }, {
    key: "lowerValueIsValid",
    get: function get() {
      return isWithinRange(this.props.min, this.upperValue, this.lowerValue);
    }
  }, {
    key: "upperValueIsValid",
    get: function get() {
      return isWithinRange(this.lowerValue, this.props.max, this.upperValue);
    }
  }, {
    key: "isValid",
    get: function get() {
      return this.lowerValueIsValid && this.upperValueIsValid;
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _ref2 = this.context,
        defaultFullWidth = _ref2.defaultFullWidth;
      var _this$props = this.props,
        className = _this$props.className,
        customCss = _this$props.css,
        compressed = _this$props.compressed,
        disabled = _this$props.disabled,
        _this$props$fullWidth = _this$props.fullWidth,
        fullWidth = _this$props$fullWidth === void 0 ? defaultFullWidth : _this$props$fullWidth,
        isLoading = _this$props.isLoading,
        readOnly = _this$props.readOnly,
        propsId = _this$props.id,
        maxProps = _this$props.max,
        minProps = _this$props.min,
        name = _this$props.name,
        step = _this$props.step,
        showLabels = _this$props.showLabels,
        showInput = _this$props.showInput,
        showTicks = _this$props.showTicks,
        tickInterval = _this$props.tickInterval,
        ticks = _this$props.ticks,
        levels = _this$props.levels,
        _onBlur = _this$props.onBlur,
        onChange = _this$props.onChange,
        _onFocus = _this$props.onFocus,
        showRange = _this$props.showRange,
        value = _this$props.value,
        isInvalid = _this$props.isInvalid,
        append = _this$props.append,
        prepend = _this$props.prepend,
        minInputProps = _this$props.minInputProps,
        maxInputProps = _this$props.maxInputProps,
        inputPopoverProps = _this$props.inputPopoverProps,
        isDraggable = _this$props.isDraggable,
        theme = _this$props.theme,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var min = minProps;
      var max = maxProps;
      var id = this.state.id;
      var showInputOnly = this.isInPopover;
      var canShowDropdown = showInputOnly && !readOnly && !disabled;
      var rangeStyles = euiRangeStyles(theme);
      var minInput = !!showInput ? ___EmotionJSX(EuiRangeInput
      // Overridable props
      , _extends({
        "aria-describedby": this.props['aria-describedby'],
        "aria-label": this.props['aria-label'],
        disabled: disabled,
        isInvalid: isInvalid,
        name: "".concat(name, "-minValue"),
        value: this.lowerValue,
        readOnly: readOnly
      }, minInputProps, {
        // Non-overridable props
        side: "min",
        min: min,
        max: this.upperValue === '' ? max : Number(this.upperValue),
        step: step,
        compressed: compressed,
        autoSize: !showInputOnly,
        fullWidth: !!showInputOnly && fullWidth,
        controlOnly: showInputOnly,
        onChange: function onChange(event) {
          var _minInputProps$onChan;
          _this2.handleLowerInputChange(event);
          minInputProps === null || minInputProps === void 0 || (_minInputProps$onChan = minInputProps.onChange) === null || _minInputProps$onChan === void 0 || _minInputProps$onChan.call(minInputProps, event);
        },
        onKeyDown: function onKeyDown(event) {
          var _minInputProps$onKeyD;
          _this2.handleInputKeyDown(event);
          minInputProps === null || minInputProps === void 0 || (_minInputProps$onKeyD = minInputProps.onKeyDown) === null || _minInputProps$onKeyD === void 0 || _minInputProps$onKeyD.call(minInputProps, event);
        },
        onFocus: function onFocus(event) {
          var _minInputProps$onFocu;
          if (canShowDropdown) {
            _this2.onInputFocus(event);
          } else {
            _onFocus === null || _onFocus === void 0 || _onFocus(event);
          }
          minInputProps === null || minInputProps === void 0 || (_minInputProps$onFocu = minInputProps.onFocus) === null || _minInputProps$onFocu === void 0 || _minInputProps$onFocu.call(minInputProps, event);
        },
        onBlur: function onBlur(event) {
          var _minInputProps$onBlur;
          if (canShowDropdown) {
            _this2.onInputBlur(event);
          } else {
            _onBlur === null || _onBlur === void 0 || _onBlur(event);
          }
          minInputProps === null || minInputProps === void 0 || (_minInputProps$onBlur = minInputProps.onBlur) === null || _minInputProps$onBlur === void 0 || _minInputProps$onBlur.call(minInputProps, event);
        },
        onMouseDown: function onMouseDown(event) {
          var _minInputProps$onMous;
          if (showInputOnly) {
            _this2.preventPopoverClose = true;
          }
          minInputProps === null || minInputProps === void 0 || (_minInputProps$onMous = minInputProps.onMouseDown) === null || _minInputProps$onMous === void 0 || _minInputProps$onMous.call(minInputProps, event);
        }
      })) : undefined;
      var maxInput = !!showInput ? ___EmotionJSX(EuiRangeInput
      // Overridable props
      , _extends({
        "aria-describedby": this.props['aria-describedby'],
        "aria-label": this.props['aria-label'],
        disabled: disabled,
        isInvalid: isInvalid,
        name: "".concat(name, "-maxValue"),
        value: this.upperValue,
        readOnly: readOnly
      }, maxInputProps, {
        // Non-overridable props
        side: "max",
        min: this.lowerValue === '' ? min : Number(this.lowerValue),
        max: max,
        step: step,
        compressed: compressed,
        autoSize: !showInputOnly,
        fullWidth: !!showInputOnly && fullWidth,
        controlOnly: showInputOnly,
        onChange: function onChange(event) {
          var _maxInputProps$onChan;
          _this2.handleUpperInputChange(event);
          maxInputProps === null || maxInputProps === void 0 || (_maxInputProps$onChan = maxInputProps.onChange) === null || _maxInputProps$onChan === void 0 || _maxInputProps$onChan.call(maxInputProps, event);
        },
        onKeyDown: function onKeyDown(event) {
          var _maxInputProps$onKeyD;
          _this2.handleInputKeyDown(event);
          maxInputProps === null || maxInputProps === void 0 || (_maxInputProps$onKeyD = maxInputProps.onKeyDown) === null || _maxInputProps$onKeyD === void 0 || _maxInputProps$onKeyD.call(maxInputProps, event);
        },
        onFocus: function onFocus(event) {
          var _maxInputProps$onFocu;
          if (canShowDropdown) {
            _this2.onInputFocus(event);
          } else {
            _onFocus === null || _onFocus === void 0 || _onFocus(event);
          }
          maxInputProps === null || maxInputProps === void 0 || (_maxInputProps$onFocu = maxInputProps.onFocus) === null || _maxInputProps$onFocu === void 0 || _maxInputProps$onFocu.call(maxInputProps, event);
        },
        onBlur: function onBlur(event) {
          var _maxInputProps$onBlur;
          if (canShowDropdown) {
            _this2.onInputBlur(event);
          } else {
            _onBlur === null || _onBlur === void 0 || _onBlur(event);
          }
          maxInputProps === null || maxInputProps === void 0 || (_maxInputProps$onBlur = maxInputProps.onBlur) === null || _maxInputProps$onBlur === void 0 || _maxInputProps$onBlur.call(maxInputProps, event);
        },
        onMouseDown: function onMouseDown(event) {
          var _maxInputProps$onMous;
          if (showInputOnly) {
            _this2.preventPopoverClose = true;
          }
          maxInputProps === null || maxInputProps === void 0 || (_maxInputProps$onMous = maxInputProps.onMouseDown) === null || _maxInputProps$onMous === void 0 || _maxInputProps$onMous.call(maxInputProps, event);
        }
      })) : undefined;
      var classes = classNames('euiDualRange', className);
      var dualRangeStyles = euiDualRangeStyles();
      var cssStyles = [dualRangeStyles.euiDualRange, customCss];
      var leftThumbPosition = this.state.rangeWidth ? this.calculateThumbPositionStyle(Number(this.lowerValue) || min, this.state.rangeWidth) : {
        left: '0'
      };
      var rightThumbPosition = this.state.rangeWidth ? this.calculateThumbPositionStyle(Number(this.upperValue) || max, this.state.rangeWidth) : {
        left: '0'
      };
      var leftThumbColor = levels && getLevelColor(levels, Number(this.lowerValue));
      var rightThumbColor = levels && getLevelColor(levels, Number(this.upperValue));
      var leftThumbStyles = leftThumbColor ? _objectSpread(_objectSpread({}, leftThumbPosition), {}, {
        backgroundColor: euiRangeLevelColor(leftThumbColor, theme.euiTheme)
      }) : leftThumbPosition;
      var rightThumbStyles = rightThumbColor ? _objectSpread(_objectSpread({}, rightThumbPosition), {}, {
        backgroundColor: euiRangeLevelColor(rightThumbColor, theme.euiTheme)
      }) : rightThumbPosition;
      var dualSliderScreenReaderInstructions = ___EmotionJSX(EuiI18n, {
        token: "euiDualRange.sliderScreenReaderInstructions",
        default: "You are in a custom range slider. Use the Up and Down arrow keys to change the minimum value. Press Tab to interact with the maximum value."
      });
      var theRange = ___EmotionJSX(EuiRangeWrapper, {
        css: cssStyles,
        className: classes,
        fullWidth: fullWidth,
        compressed: compressed
      }, showInput && !showInputOnly && ___EmotionJSX(React.Fragment, null, minInput, ___EmotionJSX("div", {
        className: showTicks || ticks ? 'euiRange__slimHorizontalSpacer' : 'euiRange__horizontalSpacer',
        css: showTicks || ticks ? rangeStyles.euiRange__slimHorizontalSpacer : rangeStyles.euiRange__horizontalSpacer
      })), showLabels && ___EmotionJSX(EuiRangeLabel, {
        side: "min",
        disabled: disabled
      }, min), ___EmotionJSX(EuiRangeTrack, {
        trackWidth: this.state.rangeWidth,
        compressed: compressed,
        disabled: disabled,
        max: max,
        min: min,
        step: step,
        showTicks: showTicks,
        tickInterval: tickInterval,
        ticks: ticks,
        levels: levels,
        onChange: this.handleSliderChange,
        value: value,
        "aria-hidden": showInput === true,
        showRange: showRange
      }, ___EmotionJSX(EuiRangeSlider, _extends({
        className: "euiDualRange__slider",
        css: dualRangeStyles.euiDualRange__slider,
        id: id,
        name: name,
        min: min,
        max: max,
        step: step,
        disabled: disabled,
        onChange: this.handleSliderChange,
        showTicks: showTicks,
        "aria-hidden": true,
        tabIndex: -1,
        showRange: showRange,
        onFocus: _onFocus,
        onBlur: _onBlur
      }, rest, {
        onResize: this.setRangeWidth
      })), isDraggable && this.isValid && ___EmotionJSX(EuiRangeDraggable, {
        min: min,
        max: max,
        value: [this.lowerValue, this.upperValue],
        disabled: disabled,
        lowerPosition: leftThumbPosition.left,
        upperPosition: rightThumbPosition.left,
        showTicks: showTicks,
        onChange: this.handleDrag,
        onFocus: this.onThumbFocus,
        onBlur: this.onThumbBlur,
        onKeyDown: this.handleDraggableKeyDown,
        "aria-describedby": showInputOnly ? undefined : this.props['aria-describedby'],
        "aria-label": showInputOnly ? undefined : this.props['aria-label']
      }), ___EmotionJSX(EuiRangeThumb, {
        min: min,
        max: Number(this.upperValue),
        value: this.lowerValue,
        disabled: disabled,
        showTicks: showTicks,
        showInput: !!showInput,
        onKeyDown: this.handleLowerKeyDown,
        onFocus: this.onThumbFocus,
        onBlur: this.onThumbBlur,
        style: logicalStyles(leftThumbStyles),
        "aria-describedby": showInputOnly ? undefined : this.props['aria-describedby'],
        "aria-label": showInputOnly ? undefined : this.props['aria-label']
      }), ___EmotionJSX(EuiRangeThumb, {
        min: Number(this.lowerValue),
        max: max,
        value: this.upperValue,
        disabled: disabled,
        showTicks: showTicks,
        showInput: !!showInput,
        onKeyDown: this.handleUpperKeyDown,
        onFocus: this.onThumbFocus,
        onBlur: this.onThumbBlur,
        style: logicalStyles(rightThumbStyles),
        "aria-describedby": showInputOnly ? undefined : this.props['aria-describedby'],
        "aria-label": showInputOnly ? undefined : this.props['aria-label']
      }), showRange && this.isValid && ___EmotionJSX(EuiRangeHighlight, {
        showTicks: showTicks,
        min: Number(min),
        max: Number(max),
        lowerValue: Number(this.lowerValue),
        upperValue: Number(this.upperValue),
        levels: levels,
        trackWidth: this.state.rangeWidth
      })), showLabels && ___EmotionJSX(EuiRangeLabel, {
        disabled: disabled
      }, max), showInput && !showInputOnly && ___EmotionJSX(React.Fragment, null, ___EmotionJSX("div", {
        className: showTicks || ticks ? 'euiRange__slimHorizontalSpacer' : 'euiRange__horizontalSpacer',
        css: showTicks || ticks ? rangeStyles.euiRange__slimHorizontalSpacer : rangeStyles.euiRange__horizontalSpacer
      }), maxInput));
      var thePopover = showInputOnly ? ___EmotionJSX(EuiInputPopover, _extends({}, inputPopoverProps, {
        className: classNames('euiDualRange__popover', inputPopoverProps === null || inputPopoverProps === void 0 ? void 0 : inputPopoverProps.className),
        input: ___EmotionJSX(EuiFormControlLayoutDelimited, {
          startControl: minInput,
          endControl: maxInput,
          isDisabled: disabled,
          fullWidth: fullWidth,
          compressed: compressed,
          readOnly: readOnly,
          append: append,
          prepend: prepend,
          isLoading: isLoading,
          isInvalid: isInvalid
        }),
        fullWidth: fullWidth,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        disableFocusTrap: true,
        popoverScreenReaderText: dualSliderScreenReaderInstructions
      }), theRange) : undefined;
      return thePopover || theRange;
    }
  }]);
}(Component);
_defineProperty(EuiDualRangeClass, "contextType", FormContext);
_defineProperty(EuiDualRangeClass, "defaultProps", {
  min: 0,
  max: 100,
  step: 1,
  compressed: false,
  isLoading: false,
  showLabels: false,
  showInput: false,
  showRange: true,
  showTicks: false,
  levels: []
});
export var EuiDualRange = withEuiTheme(EuiDualRangeClass);