import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />

import React, { useState } from 'react';
import { EuiDualRange } from './dual_range';
import { EuiRange } from './range';
import { jsx as ___EmotionJSX } from "@emotion/react";
describe('Single EuiRange', function () {
  var SingleRange = function SingleRange() {
    var _useState = useState('100'),
      _useState2 = _slicedToArray(_useState, 2),
      value = _useState2[0],
      setValue = _useState2[1];
    var onChange = function onChange(e) {
      setValue(e.currentTarget.value);
    };
    return ___EmotionJSX(EuiRange, {
      id: "cy-range-single",
      min: 100,
      max: 200,
      value: value,
      onChange: onChange,
      showLabels: true,
      showRange: true,
      showValue: true,
      valuePrepend: "100 - ",
      "aria-label": "An example of EuiRange with valuePrepend prop"
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount(___EmotionJSX(SingleRange, null));
    cy.get('div.euiRangeWrapper').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility check', function () {
    it('has zero violations when the range slider is increased', function () {
      cy.get('input#cy-range-single').focus();
      cy.repeatRealPress('ArrowRight', 10);
      cy.get('output.euiRangeTooltip__value').contains('100 - 110');
      cy.checkAxe();
    });
    it('has zero violations when the range slider is decreased', function () {
      cy.get('input#cy-range-single').focus();
      cy.repeatRealPress('ArrowLeft', 10);
      cy.get('output.euiRangeTooltip__value').contains('100 - 100');
      cy.checkAxe();
    });
  });
});
describe('Dual EuiRange', function () {
  var DualRange = function DualRange() {
    var _useState3 = useState(['100', '150']),
      _useState4 = _slicedToArray(_useState3, 2),
      dualValue = _useState4[0],
      setDualValue = _useState4[1];
    var onDualChange = function onDualChange(value) {
      setDualValue(value);
    };
    return ___EmotionJSX(EuiDualRange, {
      id: "cy-range-dual",
      min: 0,
      max: 300,
      step: 10,
      value: dualValue,
      onChange: onDualChange,
      showLabels: true,
      "aria-label": "An example of EuiDualRange"
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount(___EmotionJSX(DualRange, null));
    cy.get('div.euiRangeWrapper').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility check', function () {
    it('has zero violations when the range sliders are adjusted', function () {
      cy.get('div[role="slider"]').first().focus();
      cy.repeatRealPress('ArrowLeft', 3);
      cy.get('div[role="slider"]').first().invoke('attr', 'aria-valuenow').should('eq', '70');
      cy.realPress('Tab');
      cy.get('div[role="slider"]').last().should('have.focus');
      cy.repeatRealPress('ArrowRight', 3);
      cy.get('div[role="slider"]').last().invoke('attr', 'aria-valuenow').should('eq', '180');
      cy.checkAxe();
    });
  });
});
describe('Highlight Area EuiRange', function () {
  var DraggableRange = function DraggableRange() {
    var _useState5 = useState(['40', '60']),
      _useState6 = _slicedToArray(_useState5, 2),
      dualValue = _useState6[0],
      setDualValue = _useState6[1];
    return ___EmotionJSX(EuiDualRange, {
      id: "cy-range-draggable",
      min: 0,
      max: 100,
      step: 1,
      value: dualValue,
      onChange: setDualValue,
      showLabels: true,
      "aria-label": "An example of EuiDualRange with isDraggable='true'",
      isDraggable: true
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount(___EmotionJSX(DraggableRange, null));
    cy.get('div.euiRangeWrapper').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility check', function () {
    it('has zero violations when the highlight area is adjusted using arrow keys', function () {
      cy.get('div[role="slider"]').first().focus();
      cy.repeatRealPress('ArrowLeft', 3);
      cy.get('div[role="slider"]').first().invoke('attr', 'aria-valuetext').should('eq', '37, 57');
      cy.checkAxe();
    });
  });
  describe('Drag and drop accessibility check', function () {
    it('has zero violations when the higlight area is dragged using a mouse', function () {
      cy.get('.euiRangeDraggable__inner').realMouseDown({
        position: 'center'
      }).realMouseMove(100, 0, {}).realMouseUp();
      cy.checkAxe();
    });
  });
  describe('EuiRange in a dropdown', function () {
    var InputWithRange = function InputWithRange() {
      var _useState7 = useState('20'),
        _useState8 = _slicedToArray(_useState7, 2),
        value = _useState8[0],
        setValue = _useState8[1];
      return ___EmotionJSX(EuiRange, {
        id: "cy-range-in-dropdown",
        min: 0,
        max: 100,
        value: value,
        onChange: function onChange(e) {
          return setValue(e.currentTarget.value);
        },
        showInput: "inputWithPopover",
        showLabels: true,
        "aria-label": "An example of EuiRange with showInput prop"
      });
    };
    beforeEach(function () {
      cy.viewport(1024, 768); // medium breakpoint
      cy.realMount(___EmotionJSX(InputWithRange, null));
      cy.get('input#cy-range-in-dropdown').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations on first render', function () {
        cy.checkAxe();
      });
    });
    describe('Keyboard accessibility check', function () {
      it('updates the range value using arrow keys with input[type="number"]', function () {
        cy.get('input#cy-range-in-dropdown').focus();
        cy.repeatRealPress('ArrowUp', 10);
        cy.get('input[type="range"]').first().invoke('attr', 'value').should('eq', '30');
        cy.checkAxe();
      });
    });
  });
});