import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["className", "compressed", "disabled", "fullWidth", "isLoading", "readOnly", "id", "max", "min", "name", "step", "showLabels", "showInput", "inputPopoverProps", "showTicks", "tickInterval", "ticks", "levels", "showRange", "showValue", "valueAppend", "valuePrepend", "onBlur", "onChange", "onFocus", "value", "tabIndex", "isInvalid", "theme"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import { isWithinRange } from '../../../services/number';
import { EuiInputPopover } from '../../popover';
import { htmlIdGenerator, withEuiTheme } from '../../../services/';
import { FormContext } from '../eui_form_context';
import { getLevelColor } from './range_levels_colors';
import { EuiRangeHighlight } from './range_highlight';
import { EuiRangeInput } from './range_input';
import { EuiRangeLabel } from './range_label';
import { EuiRangeSlider } from './range_slider';
import { EuiRangeTooltip } from './range_tooltip';
import { EuiRangeTrack } from './range_track';
import { EuiRangeWrapper } from './range_wrapper';
import { euiRangeStyles } from './range.styles';
import { EuiI18n } from '../../i18n';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRangeClass = /*#__PURE__*/function (_Component) {
  function EuiRangeClass() {
    var _this;
    _classCallCheck(this, EuiRangeClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiRangeClass, [].concat(args));
    _defineProperty(_this, "preventPopoverClose", false);
    _defineProperty(_this, "state", {
      id: _this.props.id || htmlIdGenerator()(),
      isPopoverOpen: false,
      trackWidth: 0
    });
    _defineProperty(_this, "handleOnChange", function (e) {
      var isValid = isWithinRange(_this.props.min, _this.props.max, e.currentTarget.value);
      if (_this.props.onChange) {
        _this.props.onChange(e, isValid);
      }
    });
    _defineProperty(_this, "setTrackWidth", function (_ref) {
      var width = _ref.width;
      _this.setState({
        trackWidth: width
      });
    });
    _defineProperty(_this, "onInputFocus", function (e) {
      if (_this.props.onFocus) {
        _this.props.onFocus(e);
      }
      _this.setState({
        isPopoverOpen: true
      });
    });
    _defineProperty(_this, "onInputBlur", function (e) {
      return setTimeout(function () {
        // Safari does not recognize any focus-related eventing for input[type=range]
        // making it impossible to capture its state using active/focus/relatedTarget
        // Instead, a prevention flag is set on mousedown, with a waiting period here.
        // Mousedown is viable because in the popover case, it is inaccessible via keyboard (intentionally)
        if (_this.preventPopoverClose) {
          _this.preventPopoverClose = false;
          return;
        }
        if (_this.props.onBlur) {
          _this.props.onBlur(e);
        }
        _this.closePopover();
      }, 200);
    });
    _defineProperty(_this, "closePopover", function () {
      _this.preventPopoverClose = false;
      _this.setState({
        isPopoverOpen: false
      });
    });
    _defineProperty(_this, "handleAriaValueText", function (ticks, currentVal) {
      var target = ticks.find(function (tick) {
        return tick.value.toString() === currentVal.toString();
      });
      if (target) {
        return target.accessibleLabel ? "".concat(target.value, ", (").concat(target.accessibleLabel, ")") : typeof target.label === 'string' // Fall back to the label if it's a usable string
        ? "".concat(target.value, ", (").concat(target.label, ")") : undefined;
      }
    });
    return _this;
  }
  _inherits(EuiRangeClass, _Component);
  return _createClass(EuiRangeClass, [{
    key: "isValid",
    get: function get() {
      return isWithinRange(this.props.min, this.props.max, this.props.value || '');
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _ref2 = this.context,
        defaultFullWidth = _ref2.defaultFullWidth;
      var _this$props = this.props,
        className = _this$props.className,
        compressed = _this$props.compressed,
        disabled = _this$props.disabled,
        _this$props$fullWidth = _this$props.fullWidth,
        fullWidth = _this$props$fullWidth === void 0 ? defaultFullWidth : _this$props$fullWidth,
        isLoading = _this$props.isLoading,
        readOnly = _this$props.readOnly,
        propsId = _this$props.id,
        max = _this$props.max,
        min = _this$props.min,
        name = _this$props.name,
        step = _this$props.step,
        showLabels = _this$props.showLabels,
        showInput = _this$props.showInput,
        inputPopoverProps = _this$props.inputPopoverProps,
        showTicks = _this$props.showTicks,
        tickInterval = _this$props.tickInterval,
        ticks = _this$props.ticks,
        levels = _this$props.levels,
        showRange = _this$props.showRange,
        showValue = _this$props.showValue,
        valueAppend = _this$props.valueAppend,
        valuePrepend = _this$props.valuePrepend,
        onBlur = _this$props.onBlur,
        onChange = _this$props.onChange,
        onFocus = _this$props.onFocus,
        value = _this$props.value,
        tabIndex = _this$props.tabIndex,
        isInvalid = _this$props.isInvalid,
        theme = _this$props.theme,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var id = this.state.id;
      var showInputOnly = showInput === 'inputWithPopover';
      var canShowDropdown = showInputOnly && !readOnly && !disabled;
      var theInput = !!showInput ? ___EmotionJSX(EuiRangeInput, _extends({
        id: id,
        min: min,
        max: max,
        step: step,
        value: value,
        readOnly: readOnly,
        disabled: disabled,
        compressed: compressed,
        onChange: this.handleOnChange,
        name: name,
        onFocus: canShowDropdown ? this.onInputFocus : onFocus,
        onBlur: canShowDropdown ? this.onInputBlur : onBlur,
        fullWidth: showInputOnly && fullWidth,
        isLoading: showInputOnly && isLoading,
        isInvalid: isInvalid,
        autoSize: !showInputOnly
      }, rest)) : null;
      var classes = classNames('euiRange', className);
      var styles = euiRangeStyles(theme);
      var cssStyles = [styles.euiRange, showInput && styles.hasInput];
      var thumbColor = levels && getLevelColor(levels, Number(value));
      var sliderScreenReaderInstructions = ___EmotionJSX(EuiI18n, {
        token: "euiRange.sliderScreenReaderInstructions",
        default: "You are in a custom range slider. Use the Up and Down arrow keys to change the value."
      });
      var theRange = ___EmotionJSX(EuiRangeWrapper, {
        className: classes,
        css: cssStyles,
        fullWidth: fullWidth,
        compressed: compressed
      }, showLabels && ___EmotionJSX(EuiRangeLabel, {
        side: "min",
        disabled: disabled
      }, min), ___EmotionJSX(EuiRangeTrack, {
        trackWidth: this.state.trackWidth,
        disabled: disabled,
        compressed: compressed,
        max: max,
        min: min,
        step: step,
        showTicks: showTicks,
        tickInterval: tickInterval,
        ticks: ticks,
        levels: levels,
        onChange: this.handleOnChange,
        value: value,
        "aria-hidden": !!showInput,
        showRange: showRange
      }, ___EmotionJSX(EuiRangeSlider, _extends({
        ariaValueText: ticks ? this.handleAriaValueText(ticks, value) : undefined,
        id: showInput ? undefined : id // Attach id only to the input if there is one
        ,
        name: name,
        min: min,
        max: max,
        step: step,
        value: value,
        disabled: disabled,
        onChange: this.handleOnChange,
        showTicks: showTicks,
        showRange: showRange,
        tabIndex: showInput ? -1 : tabIndex,
        onMouseDown: showInputOnly ? function () {
          return _this2.preventPopoverClose = true;
        } : undefined,
        onFocus: showInput === true ? undefined : onFocus,
        onBlur: showInputOnly ? this.onInputBlur : onBlur,
        "aria-hidden": !!showInput,
        thumbColor: thumbColor
      }, rest, {
        onResize: this.setTrackWidth
      })), showRange && this.isValid && ___EmotionJSX(EuiRangeHighlight, {
        showTicks: showTicks,
        min: Number(min),
        max: Number(max),
        lowerValue: Number(min),
        upperValue: Number(value),
        levels: levels,
        trackWidth: this.state.trackWidth
      }), showValue && !!String(value).length && ___EmotionJSX(EuiRangeTooltip, {
        value: value,
        max: max,
        min: min,
        name: name,
        showTicks: showTicks,
        valuePrepend: valuePrepend,
        valueAppend: valueAppend
      })), showLabels && ___EmotionJSX(EuiRangeLabel, {
        side: "max",
        disabled: disabled
      }, max), showInput && !showInputOnly && ___EmotionJSX(React.Fragment, null, ___EmotionJSX("div", {
        className: showTicks || ticks ? 'euiRange__slimHorizontalSpacer' : 'euiRange__horizontalSpacer',
        css: showTicks || ticks ? styles.euiRange__slimHorizontalSpacer : styles.euiRange__horizontalSpacer
      }), theInput));
      var thePopover = showInputOnly ? ___EmotionJSX(EuiInputPopover, _extends({}, inputPopoverProps, {
        className: classNames('euiRange__popover', inputPopoverProps === null || inputPopoverProps === void 0 ? void 0 : inputPopoverProps.className),
        input: theInput // `showInputOnly` confirms existence
        ,
        fullWidth: fullWidth,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        disableFocusTrap: true,
        popoverScreenReaderText: sliderScreenReaderInstructions
      }), theRange) : undefined;
      return thePopover ? thePopover : theRange;
    }
  }]);
}(Component);
_defineProperty(EuiRangeClass, "contextType", FormContext);
_defineProperty(EuiRangeClass, "defaultProps", {
  min: 0,
  max: 100,
  step: 1,
  compressed: false,
  isLoading: false,
  showLabels: false,
  showInput: false,
  showRange: false,
  showTicks: false,
  showValue: false,
  levels: []
});
export var EuiRange = withEuiTheme(EuiRangeClass);