import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "showTicks", "lowerPosition", "upperPosition", "onChange", "min", "max", "disabled", "value"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useMemo } from 'react';
import classNames from 'classnames';
import { useMouseMove, useEuiTheme, useEuiMemoizedStyles } from '../../../services';
import { logicalStyles } from '../../../global_styling';
import { euiRangeDraggableStyles, euiRangeDraggableInnerStyles } from './range_draggable.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRangeDraggable = function EuiRangeDraggable(_ref) {
  var className = _ref.className,
    showTicks = _ref.showTicks,
    lowerPosition = _ref.lowerPosition,
    upperPosition = _ref.upperPosition,
    onChange = _ref.onChange,
    min = _ref.min,
    max = _ref.max,
    disabled = _ref.disabled,
    value = _ref.value,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = useEuiTheme();
  var outerStyle = useMemo(function () {
    return logicalStyles({
      left: lowerPosition,
      right: "calc(100% - ".concat(upperPosition, " - ").concat(euiTheme.euiTheme.size.base, ")")
    });
  }, [lowerPosition, upperPosition, euiTheme.euiTheme.size.base]);
  var handleChange = useCallback(function (_ref2, isFirstInteraction) {
    var x = _ref2.x;
    if (disabled) return;
    onChange(x, isFirstInteraction);
  }, [disabled, onChange]);
  var _useMouseMove = useMouseMove(handleChange),
    _useMouseMove2 = _slicedToArray(_useMouseMove, 2),
    handleMouseDown = _useMouseMove2[0],
    handleInteraction = _useMouseMove2[1];
  var classes = classNames('euiRangeDraggable', className);
  var styles = useEuiMemoizedStyles(euiRangeDraggableStyles);
  var cssStyles = [styles.euiRangeDraggable, showTicks && styles.hasTicks, disabled && styles.disabled];
  var innerStyles = useEuiMemoizedStyles(euiRangeDraggableInnerStyles);
  var cssInnerStyles = [innerStyles.euiRangeDraggable__inner, disabled ? styles.disabled : innerStyles.enabled];
  var commonProps = {
    className: classes,
    css: cssStyles,
    role: 'slider',
    'aria-valuemin': min,
    'aria-valuemax': max,
    'aria-valuenow': Number(value[0]),
    'aria-valuetext': "".concat(value[0], ", ").concat(value[1]),
    'aria-disabled': !!disabled,
    tabIndex: !!disabled ? -1 : 0
  };
  return ___EmotionJSX("div", _extends({
    style: outerStyle
  }, commonProps, rest), ___EmotionJSX("div", {
    className: "euiRangeDraggable__inner",
    css: cssInnerStyles,
    onMouseDown: handleMouseDown,
    onTouchStart: handleInteraction,
    onTouchMove: handleInteraction
  }));
};