/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiRangeVariables } from './range.styles';
export var euiRangeHighlightStyles = function euiRangeHighlightStyles(euiThemeContext) {
  var range = euiRangeVariables(euiThemeContext);
  return {
    euiRangeHighlight: /*#__PURE__*/css("position:absolute;block-size:", range.highlightHeight, ";inset-inline-start:0;inline-size:100%;overflow:hidden;z-index:", range.highlightZIndex, ";pointer-events:none;inset-block-start:", range.trackTopPositionWithoutTicks, ";;label:euiRangeHighlight;"),
    hasTicks: /*#__PURE__*/css("inset-block-start:", range.trackTopPositionWithTicks, ";;label:hasTicks;")
  };
};
export var euiRangeHighlightProgressStyles = function euiRangeHighlightProgressStyles(euiThemeContext) {
  var range = euiRangeVariables(euiThemeContext);
  return {
    euiRangeHighlight__progress: /*#__PURE__*/css("block-size:", range.highlightHeight, ";border-radius:", range.trackBorderRadius, ";background-color:", range.highlightColor, ";.euiRangeSlider:focus-visible~.euiRangeHighlight &,.euiRangeThumb:focus-visible~.euiRangeHighlight &,.euiRangeDraggable:focus~.euiRangeHighlight &{background-color:", range.focusColor, ";};label:euiRangeHighlight__progress;")
  };
};
export var euiRangeHighlightLevelsWrapperStyles = function euiRangeHighlightLevelsWrapperStyles(euiThemeContext) {
  var euiRangeVars = euiRangeVariables(euiThemeContext);
  return {
    euiRangeHighlight__levelsWrapper: /*#__PURE__*/css("block-size:", euiRangeVars.trackHeight, ";position:relative;overflow:hidden;;label:euiRangeHighlight__levelsWrapper;")
  };
};
export var euiRangeHighlightLevelsStyles = function euiRangeHighlightLevelsStyles(euiThemeContext) {
  var euiRangeVars = euiRangeVariables(euiThemeContext);
  return {
    euiRangeHighlight__levels: /*#__PURE__*/css("background:transparent;block-size:", euiRangeVars.trackHeight, ";inset-block-start:0;;label:euiRangeHighlight__levels;")
  };
};