import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["min", "max", "step", "value", "inputRef", "isInvalid", "disabled", "compressed", "onChange", "name", "side", "fullWidth", "autoSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useEffect, useMemo, useRef } from 'react';
import { useEuiTheme, useCombinedRefs } from '../../../services';
import { logicalStyles } from '../../../global_styling';
import { euiFormVariables } from '../form.styles';
import { EuiFieldNumber } from '../field_number';
import { euiRangeInputStyles } from './range_input.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRangeInput = function EuiRangeInput(_ref) {
  var min = _ref.min,
    max = _ref.max,
    step = _ref.step,
    value = _ref.value,
    inputRef = _ref.inputRef,
    isInvalid = _ref.isInvalid,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    onChange = _ref.onChange,
    name = _ref.name,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'max' : _ref$side,
    fullWidth = _ref.fullWidth,
    _ref$autoSize = _ref.autoSize,
    autoSize = _ref$autoSize === void 0 ? true : _ref$autoSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = useEuiTheme();
  var styles = euiRangeInputStyles(euiTheme);
  var cssStyles = [styles.euiRangeInput];

  // Determine whether an invalid icon is showing, which can come from
  // the underlying EuiFieldNumber's native :invalid state
  var _useState = useState(isInvalid),
    _useState2 = _slicedToArray(_useState, 2),
    hasInvalidIcon = _useState2[0],
    setHasInvalidIcon = _useState2[1];
  var validityRef = useRef(null);
  var setRefs = useCombinedRefs([validityRef, inputRef]);
  useEffect(function () {
    var _validityRef$current;
    var isNativelyInvalid = !((_validityRef$current = validityRef.current) !== null && _validityRef$current !== void 0 && _validityRef$current.validity.valid);
    setHasInvalidIcon(isNativelyInvalid || isInvalid);
  }, [value, isInvalid]);

  // Calculate the auto size width of the input
  var widthStyle = useMemo(function () {
    if (!autoSize) return undefined;

    // Calculate the number of characters to show (dynamic based on user input)
    // Uses the min/max char length as a max, then add an extra UX buffer of 1
    var maxChars = Math.max(String(min).length, String(max).length) + 1;
    var inputCharWidth = Math.min(String(value).length, maxChars);

    // Calculate the form padding based on `compressed` state
    var _euiFormVariables = euiFormVariables(euiTheme),
      controlPadding = _euiFormVariables.controlPadding,
      controlCompressedPadding = _euiFormVariables.controlCompressedPadding;
    var inputPadding = compressed ? controlCompressedPadding : controlPadding;

    // Calculate the invalid icon (if being displayed), also based on `compressed` state
    var invalidIconWidth = hasInvalidIcon ? euiTheme.euiTheme.base * (compressed ? 1.125 : 1.375) // TODO: DRY this out once EuiFormControlLayoutIcons is converted to Emotion
    : 0;

    // Guesstimate a width for the stepper. Note that it's a little wider in FF than it is in Chrome
    var stepperWidth = 2;
    return logicalStyles({
      width: "calc(".concat(inputPadding, " + ").concat(inputCharWidth, "ch + ").concat(stepperWidth, "em + ").concat(invalidIconWidth, "px)")
    });
  }, [autoSize, euiTheme, compressed, hasInvalidIcon, min, max, value]);
  return ___EmotionJSX(EuiFieldNumber, _extends({
    name: name,
    className: "euiRangeInput euiRangeInput--".concat(side),
    css: cssStyles,
    min: Number(min),
    max: Number(max),
    step: step,
    value: value === '' ? '' : Number(value),
    inputRef: setRefs,
    isInvalid: isInvalid,
    disabled: disabled,
    compressed: compressed,
    onChange: onChange,
    style: widthStyle,
    fullWidth: fullWidth
  }, rest));
};