import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "disabled", "id", "max", "min", "name", "step", "onChange", "tabIndex", "value", "style", "showTicks", "showRange", "thumbColor", "onResize", "ariaValueText"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { logicalStyles } from '../../../global_styling';
import { EuiResizeObserver } from '../../observer/resize_observer';
import { euiRangeLevelColor } from './range_levels_colors';
import { euiRangeSliderStyles, euiRangeSliderThumbStyles } from './range_slider.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRangeSlider = function EuiRangeSlider(_ref) {
  var className = _ref.className,
    disabled = _ref.disabled,
    id = _ref.id,
    max = _ref.max,
    min = _ref.min,
    name = _ref.name,
    step = _ref.step,
    onChange = _ref.onChange,
    tabIndex = _ref.tabIndex,
    value = _ref.value,
    style = _ref.style,
    showTicks = _ref.showTicks,
    showRange = _ref.showRange,
    thumbColor = _ref.thumbColor,
    onResize = _ref.onResize,
    ariaValueText = _ref.ariaValueText,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiRangeSlider', className);
  var euiTheme = useEuiTheme();
  var styles = euiRangeSliderStyles(euiTheme);
  var thumbStyles = euiRangeSliderThumbStyles(euiTheme);
  var cssStyles = [styles.euiRangeSlider, showTicks && styles.hasTicks, showRange && styles.hasRange, thumbColor && thumbStyles.thumb];
  var sliderStyle = useMemo(function () {
    return logicalStyles(_objectSpread({
      color: thumbColor && euiRangeLevelColor(thumbColor, euiTheme.euiTheme)
    }, style));
  }, [thumbColor, euiTheme, style]);
  return ___EmotionJSX(EuiResizeObserver, {
    onResize: onResize
  }, function (resizeRef) {
    return ___EmotionJSX("input", _extends({
      "aria-valuetext": ariaValueText,
      ref: resizeRef,
      type: "range",
      id: id,
      name: name,
      className: classes,
      css: cssStyles,
      min: min,
      max: max,
      step: step,
      value: value,
      disabled: disabled,
      onChange: onChange,
      style: sliderStyle,
      tabIndex: tabIndex
    }, rest));
  });
};