/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../../services';
import { euiRangeThumbStyle, euiRangeThumbPerBrowser, euiRangeVariables, euiRangeTrackPerBrowser, euiRangeThumbFocus } from './range.styles';
export var euiRangeSliderStyles = function euiRangeSliderStyles(euiThemeContext) {
  var range = euiRangeVariables(euiThemeContext);
  return {
    // Base
    euiRangeSlider: /*#__PURE__*/css("appearance:none;background:transparent;inline-size:100%;block-size:100%;position:relative;cursor:pointer;z-index:", range.thumbZIndex, ";", euiRangeThumbPerBrowser("\n        ".concat(euiRangeThumbStyle(euiThemeContext), "\n      ")), " &:disabled{cursor:not-allowed;", euiRangeThumbPerBrowser('cursor: not-allowed'), ";}&::-webkit-slider-thumb{-webkit-appearance:none;}&:focus{outline:none;}&:focus-visible{", euiRangeThumbPerBrowser(euiRangeThumbFocus(euiThemeContext)), " &~.euiRangeTooltip .euiRangeTooltip__value{transform:translateX(0) translateY(-50%) scale(1.1);}};label:euiRangeSlider;"),
    hasTicks: /*#__PURE__*/css("block-size:", range.thumbHeight, ";;label:hasTicks;"),
    hasRange: /*#__PURE__*/css(euiRangeTrackPerBrowser("\n        background-color: transparent;\n        border-color: ".concat(transparentize(range.trackBorderColor, 0.6), "\n      ")), ";;label:hasRange;"),
    hasLevels: /*#__PURE__*/css(euiRangeThumbPerBrowser("background-color: ".concat(range.thumbBackgroundColor)), ";;label:hasLevels;")
  };
};
export var euiRangeSliderThumbStyles = function euiRangeSliderThumbStyles(euiThemeContext) {
  return {
    thumb: /*#__PURE__*/css(euiRangeThumbPerBrowser('background-color: currentcolor'), " &:focus-visible{", euiRangeThumbPerBrowser(euiRangeThumbFocus(euiThemeContext, 'currentcolor')), ";};label:thumb;")
  };
};