import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import { useEuiTheme } from '../../../services';
import { logicalStyles } from '../../../global_styling';
import { useInnerText } from '../../inner_text';
import { calculateThumbPosition, EUI_THUMB_SIZE } from './utils';
import { euiRangeTicksStyles, euiRangeTickStyles } from './range_ticks.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var EuiTickValue = function EuiTickValue(_ref) {
  var disabled = _ref.disabled,
    ticks = _ref.ticks,
    min = _ref.min,
    max = _ref.max,
    value = _ref.value,
    onChange = _ref.onChange,
    percentageWidth = _ref.percentageWidth,
    tickValue = _ref.tickValue,
    compressed = _ref.compressed,
    trackWidth = _ref.trackWidth;
  var euiTheme = useEuiTheme();
  var hasCustomTicks = !!ticks;
  var tickObject = useMemo(function () {
    return hasCustomTicks ? ticks.find(function (o) {
      return o.value === tickValue;
    }) : {
      value: tickValue,
      label: tickValue
    };
  }, [hasCustomTicks, ticks, tickValue]);
  var isMinTick = (tickObject === null || tickObject === void 0 ? void 0 : tickObject.value) === min;
  var isMaxTick = (tickObject === null || tickObject === void 0 ? void 0 : tickObject.value) === max;
  var label = tickObject ? tickObject.label : tickValue;

  // Math worked out by trial and error
  // Shifts the label into the reserved margin of EuiRangeTrack
  var labelShiftVal = useMemo(function () {
    return (isMinTick || isMaxTick) && label.length > 3 ? Math.min(label.length * 0.25, 1.25) : 0;
  }, [isMinTick, isMaxTick, label]);
  var tickStyle = useMemo(function () {
    var styles = {};
    var shift = "-".concat(labelShiftVal, "em");
    if (isMaxTick && labelShiftVal) {
      styles.right = '0%';
      styles.marginRight = shift;
    } else {
      var position = calculateThumbPosition(tickValue, min, max, trackWidth);
      var thumbOffset = labelShiftVal ? 0 : EUI_THUMB_SIZE / 2;
      styles.left = "calc(".concat(position, "% + ").concat(thumbOffset, "px)");
      if (labelShiftVal) styles.marginLeft = shift;
    }
    styles.maxWidth = hasCustomTicks ? undefined : "".concat(percentageWidth, "%");
    return logicalStyles(styles);
  }, [isMaxTick, labelShiftVal, trackWidth, tickValue, min, max, hasCustomTicks, percentageWidth]);

  // Some ticks need an actual DOM element instead of using a ::before
  var pseudoTick = tickObject && !!labelShiftVal && (isMinTick || isMaxTick);
  var pseudoShift = useMemo(function () {
    if (!labelShiftVal) return {};
    var marginProperty = isMaxTick ? 'marginRight' : 'marginLeft';
    var tickOffset = euiTheme.euiTheme.size.xs; // xs derived from .euiRangeTicks left/right offset

    return logicalStyles(_defineProperty({}, marginProperty, "calc(".concat(labelShiftVal, "em + ").concat(tickOffset, ")")));
  }, [labelShiftVal, isMaxTick, euiTheme.euiTheme.size.xs]);
  var styles = euiRangeTickStyles(euiTheme);
  var cssTickStyles = [styles.euiRangeTick, value === String(tickValue) && styles.selected, hasCustomTicks && styles.isCustom, labelShiftVal && isMinTick && styles.isMin, labelShiftVal && isMaxTick && styles.isMax, !pseudoTick && styles.hasPseudoTickMark, compressed ? styles.compressed : styles.regular];
  var _useInnerText = useInnerText(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    ref = _useInnerText2[0],
    innerText = _useInnerText2[1];
  return ___EmotionJSX("button", {
    type: "button",
    className: "euiRangeTick",
    css: cssTickStyles,
    value: tickValue,
    disabled: disabled,
    onClick: onChange,
    style: tickStyle,
    tabIndex: -1,
    ref: ref,
    title: typeof label === 'string' ? label : innerText
  }, pseudoTick && ___EmotionJSX("span", {
    className: "euiRangeTick__pseudo",
    css: styles.euiRangeTick__pseudo,
    "aria-hidden": true,
    style: pseudoShift
  }), label);
};
export var EuiRangeTicks = function EuiRangeTicks(props) {
  var ticks = props.ticks,
    tickSequence = props.tickSequence,
    max = props.max,
    min = props.min,
    _props$tickInterval = props.tickInterval,
    tickInterval = _props$tickInterval === void 0 ? 1 : _props$tickInterval,
    compressed = props.compressed;

  // Calculate the width of each tick mark
  var percentageWidth = useMemo(function () {
    return tickInterval / (max - min + tickInterval) * 100;
  }, [tickInterval, min, max]);
  var euiTheme = useEuiTheme();
  var styles = euiRangeTicksStyles(euiTheme);
  var cssStyles = [styles.euiRangeTicks, compressed ? styles.compressed : styles.regular, ticks && styles.isCustom];
  return ___EmotionJSX("div", {
    className: "euiRangeTicks",
    css: cssStyles
  }, tickSequence.map(function (tickValue) {
    return ___EmotionJSX(EuiTickValue, _extends({
      key: tickValue
    }, props, {
      percentageWidth: percentageWidth,
      tickValue: tickValue
    }));
  }));
};