/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import { useEuiTheme } from '../../../services';
import { logicalStyles } from '../../../global_styling';
import { euiRangeTooltipStyles, euiRangeTooltipValueStyles } from './range_tooltip.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRangeTooltip = function EuiRangeTooltip(_ref) {
  var value = _ref.value,
    valueAppend = _ref.valueAppend,
    valuePrepend = _ref.valuePrepend,
    max = _ref.max,
    min = _ref.min,
    name = _ref.name,
    showTicks = _ref.showTicks;
  // Calculate the left position based on value
  var valuePosition = useMemo(function () {
    var val = 0;
    if (typeof value === 'number') {
      val = value;
    } else if (typeof value === 'string') {
      val = parseFloat(value);
    }
    var decimal = (val - min) / (max - min);
    // Must be between 0-100%
    var valuePosition = decimal <= 1 ? decimal : 1;
    return valuePosition >= 0 ? valuePosition : 0;
  }, [value, min, max]);

  // Change left/right position based on value (half way point)
  var valuePositionSide = useMemo(function () {
    return valuePosition > 0.5 ? 'left' : 'right';
  }, [valuePosition]);
  var valuePositionStyle = useMemo(function () {
    if (valuePositionSide === 'left') {
      return logicalStyles({
        right: "".concat((1 - valuePosition) * 100, "%")
      });
    } else if (valuePositionSide === 'right') {
      return logicalStyles({
        left: "".concat(valuePosition * 100, "%")
      });
    }
  }, [valuePosition, valuePositionSide]);
  var euiTheme = useEuiTheme();
  var styles = euiRangeTooltipStyles(euiTheme);
  var cssStyles = [styles.euiRangeTooltip];
  var valueStyles = euiRangeTooltipValueStyles(euiTheme);
  var cssValueStyles = [valueStyles.euiRangeTooltip__value, valueStyles[valuePositionSide], showTicks && valueStyles.hasTicks];
  return ___EmotionJSX("div", {
    className: "euiRangeTooltip",
    css: cssStyles
  }, ___EmotionJSX("output", {
    className: "euiRangeTooltip__value",
    css: cssValueStyles,
    htmlFor: name,
    style: valuePositionStyle
  }, valuePrepend, value, valueAppend));
};