/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { COLOR_MODES_STANDARD, tint, shade } from '../../../services';
import { euiRangeVariables } from './range.styles';
import { euiFontSize, mathWithUnits } from '../../../global_styling';
export var euiRangeTooltipStyles = function euiRangeTooltipStyles(euiThemeContext) {
  var range = euiRangeVariables(euiThemeContext);
  return {
    // Base
    euiRangeTooltip: /*#__PURE__*/css("display:block;position:absolute;inset-inline-start:0;inset-block:0;inline-size:calc(100% - ", range.thumbWidth, ");margin-inline-start:", mathWithUnits(range.thumbWidth, function (x) {
      return x / 2;
    }), ";pointer-events:none;z-index:", range.thumbZIndex, ";;label:euiRangeTooltip;")
  };
};
var euiToolTipBackgroundColor = function euiToolTipBackgroundColor(euiTheme, colorMode) {
  return colorMode === COLOR_MODES_STANDARD.dark ? shade(euiTheme.colors.emptyShade, 1) : tint(euiTheme.colors.fullShade, 0.25);
};
export var euiRangeTooltipValueStyles = function euiRangeTooltipValueStyles(euiThemeContext) {
  var range = euiRangeVariables(euiThemeContext);
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var arrowSize = euiTheme.size.m;
  var arrowSizeInt = parseInt(arrowSize, 10);
  var arrowMinusSize = "".concat((arrowSizeInt / 2 - 1) * -1, "px"); // Shift arrow 1px more than half its size to account for border radius

  return {
    euiRangeTooltip__value: /*#__PURE__*/css("position:absolute;inset-block-start:50%;max-inline-size:", mathWithUnits(euiTheme.size.base, function (x) {
      return x * 16;
    }), ";padding-block:", euiTheme.size.xxs, ";padding-inline:", euiTheme.size.s, ";transform:translateX(0) translateY(-50%);", euiFontSize(euiThemeContext, 's'), " line-height:", euiFontSize(euiThemeContext, 's').lineHeight, ";color:", euiTheme.colors.ghost, ";background-color:", euiToolTipBackgroundColor(euiTheme, colorMode), ";border:", euiTheme.border.width.thin, " solid ", euiToolTipBackgroundColor(euiTheme, colorMode), ";border-radius:", euiTheme.border.radius.small, ";&::before{content:'';position:absolute;inset-block-end:50%;inline-size:", arrowSize, ";block-size:", arrowSize, ";transform-origin:center;transform:translateY(50%) rotateZ(45deg);background-color:", euiToolTipBackgroundColor(euiTheme, colorMode), ";border-radius:", mathWithUnits(euiTheme.border.radius.small, function (x) {
      return x / 2;
    }), ";};label:euiRangeTooltip__value;"),
    left: /*#__PURE__*/css("margin-inline-end:", euiTheme.size.l, ";&::before{inset-inline-end:", arrowMinusSize, ";};label:left;"),
    right: /*#__PURE__*/css("margin-inline-start:", euiTheme.size.l, ";&::before{inset-inline-start:", arrowMinusSize, ";};label:right;"),
    hasTicks: /*#__PURE__*/css("inset-block-start:", mathWithUnits(range.thumbWidth, function (x) {
      return x / 2;
    }), ";;label:hasTicks;")
  };
};