import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "trackWidth", "disabled", "max", "min", "step", "showTicks", "tickInterval", "ticks", "levels", "onChange", "value", "compressed", "showRange", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo, useEffect } from 'react';
import classNames from 'classnames';
import range from 'lodash/range';
import { useEuiTheme, isEvenlyDivisibleBy } from '../../../services';
import { EuiRangeLevels } from './range_levels';
import { EuiRangeTicks } from './range_ticks';
import { euiRangeTrackStyles } from './range_track.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRangeTrack = function EuiRangeTrack(_ref) {
  var children = _ref.children,
    trackWidth = _ref.trackWidth,
    disabled = _ref.disabled,
    max = _ref.max,
    min = _ref.min,
    step = _ref.step,
    showTicks = _ref.showTicks,
    tickInterval = _ref.tickInterval,
    ticks = _ref.ticks,
    levels = _ref.levels,
    onChange = _ref.onChange,
    value = _ref.value,
    compressed = _ref.compressed,
    showRange = _ref.showRange,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  useEffect(function () {
    validateValueIsInStep(max, {
      min: min,
      max: max,
      step: step
    });
  }, [value, min, max, step]);
  var tickSequence = useMemo(function () {
    if (showTicks !== true) return;
    var sequence;
    if (ticks) {
      // If custom values were passed, use those for the sequence
      // But make sure they align with the possible sequence
      sequence = ticks.map(function (tick) {
        return validateValueIsInStep(tick.value, {
          min: min,
          max: max,
          step: step
        });
      });
    } else {
      // If a custom interval was passed, use those for the sequence
      // But make sure they align with the possible sequence
      var interval = tickInterval || step;

      // Calculate sequence - loop from min to max, creating adding values at each interval
      var sequenceRange = range(min, max, interval);
      // range is non-inclusive of max, so make it inclusive
      if (max % interval === 0 && !sequenceRange.includes(max)) {
        sequenceRange.push(max);
      }
      sequence = sequenceRange.map(function (tick) {
        return validateValueIsInStep(tick, {
          min: min,
          max: max,
          step: step
        });
      });
    }

    // Error out if there are too many ticks to render
    if (trackWidth && sequence.length) {
      validateTickRenderCount(trackWidth, sequence.length);
    }
    return sequence;
  }, [showTicks, ticks, min, max, tickInterval, step, trackWidth]);
  var euiTheme = useEuiTheme();
  var styles = euiRangeTrackStyles(euiTheme);
  var cssStyles = [styles.euiRangeTrack, disabled && styles.disabled, levels && !!levels.length && styles.hasLevels, showTicks && (tickSequence || ticks) && styles.hasTicks];
  var classes = classNames('euiRangeTrack', className);
  return ___EmotionJSX("div", _extends({
    className: classes,
    css: cssStyles
  }, rest), levels && !!levels.length && ___EmotionJSX(EuiRangeLevels, {
    levels: levels,
    max: max,
    min: min,
    showTicks: showTicks,
    showRange: showRange,
    trackWidth: trackWidth
  }), tickSequence && ___EmotionJSX(EuiRangeTicks, {
    disabled: disabled,
    compressed: compressed,
    onChange: onChange,
    ticks: ticks,
    tickInterval: tickInterval || step,
    tickSequence: tickSequence,
    value: value,
    min: min,
    max: max,
    trackWidth: trackWidth
  }), children);
};
var validateValueIsInStep = function validateValueIsInStep(value, _ref2) {
  var min = _ref2.min,
    max = _ref2.max,
    step = _ref2.step;
  if (value < min) {
    throw new Error("The value of ".concat(value, " is lower than the min value of ").concat(min, "."));
  }
  if (value > max) {
    throw new Error("The value of ".concat(value, " is higher than the max value of ").concat(max, "."));
  }
  // Error out if the value doesn't line up with the sequence of steps
  if (!isEvenlyDivisibleBy(value - min, step !== undefined ? step : 1)) {
    throw new Error("The value of ".concat(value, " is not included in the possible sequence provided by the step of ").concat(step, "."));
  }
  // Return the value if nothing fails
  return value;
};
var validateTickRenderCount = function validateTickRenderCount(trackWidth, tickCount) {
  var tickWidth = trackWidth / tickCount;

  // These widths are guesstimations - it's possible we should use actual label content/widths instead
  var COMFORTABLE_TICK_WIDTH = 20; // Set a warning threshold before throwing
  var MIN_TICK_WIDTH = 5; // If ticks are smaller than this, something's gone seriously wrong and we should throw

  var message = "The number of ticks to render (".concat(tickCount, ") is too high for the range width. Ensure all ticks are visible on the page at multiple screen widths, or use EUI's breakpoint hook utilities to reduce the tick interval responsively.");
  if (tickWidth <= MIN_TICK_WIDTH) {
    throw new Error(message);
  } else if (tickWidth < COMFORTABLE_TICK_WIDTH) {
    console.warn(message);
  }
};