/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiRangeVariables } from './range.styles';
export var euiRangeTrackStyles = function euiRangeTrackStyles(euiThemeContext) {
  var range = euiRangeVariables(euiThemeContext);
  return {
    // Base
    euiRangeTrack: /*#__PURE__*/css("block-size:100%;flex-grow:1;position:relative;align-self:flex-start;&::after{content:'';display:block;position:absolute;inset-block-start:", range.trackTopPositionWithoutTicks, ";inset-inline-start:0;block-size:", range.trackHeight, ";inline-size:", range.trackWidth, ";background:", range.trackColor, ";border-radius:", range.trackBorderRadius, ";};label:euiRangeTrack;"),
    hasTicks: /*#__PURE__*/css("margin-inline-start:1em;margin-inline-end:1em;&::after{inset-block-start:", range.trackTopPositionWithTicks, ";};label:hasTicks;"),
    disabled: /*#__PURE__*/css("opacity:", range.disabledOpacity, ";;label:disabled;"),
    hasLevels: /*#__PURE__*/css(";label:hasLevels;")
  };
};