import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "fullWidth", "compressed"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef } from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { useFormContext } from '../eui_form_context';
import { euiRangeWrapperStyles } from './range_wrapper.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiRangeWrapper = /*#__PURE__*/forwardRef(function (props, ref) {
  var _useFormContext = useFormContext(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var children = props.children,
    className = props.className,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    compressed = props.compressed,
    rest = _objectWithoutProperties(props, _excluded);
  var classes = classNames('euiRangeWrapper', className);
  var euiTheme = useEuiTheme();
  var styles = euiRangeWrapperStyles(euiTheme);
  var cssStyles = [styles.euiRangeWrapper, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth];
  return ___EmotionJSX("div", _extends({
    className: classes,
    css: cssStyles,
    ref: ref
  }, rest), children);
});
EuiRangeWrapper.displayName = 'EuiRangeWrapper';