import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["className", "options", "valueOfSelected", "placeholder", "onChange", "isOpen", "isInvalid", "hasDividers", "itemClassName", "itemLayoutAlign", "fullWidth", "popoverProps", "compressed"],
  _excluded2 = ["value", "dropdownDisplay", "inputDisplay"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component, createRef } from 'react';
import classNames from 'classnames';
import { htmlIdGenerator, keys } from '../../../services';
import { EuiI18n } from '../../i18n';
import { EuiScreenReaderOnly } from '../../accessibility';
import { EuiInputPopover } from '../../popover';
import { EuiSuperSelectControl } from './super_select_control';
import { EuiSuperSelectItem } from './super_select_item';
import { euiSuperSelectStyles as styles } from './super_select.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var ShiftDirection = /*#__PURE__*/function (ShiftDirection) {
  ShiftDirection["BACK"] = "back";
  ShiftDirection["FORWARD"] = "forward";
  return ShiftDirection;
}(ShiftDirection || {});
export var EuiSuperSelect = /*#__PURE__*/function (_Component) {
  function EuiSuperSelect() {
    var _this;
    _classCallCheck(this, EuiSuperSelect);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiSuperSelect, [].concat(args));
    _defineProperty(_this, "itemNodes", []);
    _defineProperty(_this, "_isMounted", false);
    _defineProperty(_this, "controlButtonRef", /*#__PURE__*/createRef());
    _defineProperty(_this, "describedById", htmlIdGenerator('euiSuperSelect_')('_screenreaderDescribeId'));
    _defineProperty(_this, "state", {
      isPopoverOpen: _this.props.isOpen || false
    });
    _defineProperty(_this, "setItemNode", function (node, index) {
      _this.itemNodes[index] = node;
    });
    _defineProperty(_this, "openPopover", function () {
      _this.setState({
        isPopoverOpen: true
      });
      var focusSelected = function focusSelected() {
        var indexOfSelected = _this.props.options.reduce(function (indexOfSelected, option, index) {
          if (indexOfSelected != null) return indexOfSelected;
          if (option == null) return null;
          return option.value === _this.props.valueOfSelected ? index : null;
        }, null);
        requestAnimationFrame(function () {
          if (!_this._isMounted) {
            return;
          }
          if (_this.props.valueOfSelected != null && indexOfSelected != null) {
            _this.focusItemAt(indexOfSelected);
          } else {
            _this.focusItemAt(0);
          }
          if (_this.props.onFocus) {
            _this.props.onFocus();
          }
        });
      };
      requestAnimationFrame(focusSelected);
    });
    _defineProperty(_this, "closePopover", function () {
      _this.setState({
        isPopoverOpen: false
      });

      // Refocus back to the toggling control button on popover close
      requestAnimationFrame(function () {
        var _this$controlButtonRe;
        (_this$controlButtonRe = _this.controlButtonRef.current) === null || _this$controlButtonRe === void 0 || _this$controlButtonRe.focus();
      });
      if (_this.props.onBlur) {
        _this.props.onBlur();
      }
    });
    _defineProperty(_this, "itemClicked", function (value) {
      _this.closePopover();
      if (_this.props.onChange) {
        _this.props.onChange(value);
      }
    });
    _defineProperty(_this, "onSelectKeyDown", function (event) {
      // Mimic the ways native `<select>`s can be opened via keypress
      if (event.key === keys.ARROW_UP || event.key === keys.ARROW_DOWN || event.key === keys.SPACE) {
        event.preventDefault();
        event.stopPropagation();
        _this.openPopover();
      }
    });
    _defineProperty(_this, "onItemKeyDown", function (event) {
      switch (event.key) {
        case keys.ESCAPE:
          // close the popover and prevent ancestors from handling
          event.preventDefault();
          event.stopPropagation();
          _this.closePopover();
          break;
        case keys.TAB:
          // Mimic native `<select>` behavior, which selects an item on tab press
          event.preventDefault();
          event.stopPropagation();
          event.target.click();
          break;
        case keys.ARROW_UP:
          event.preventDefault();
          event.stopPropagation();
          _this.shiftFocus(ShiftDirection.BACK);
          break;
        case keys.ARROW_DOWN:
          event.preventDefault();
          event.stopPropagation();
          _this.shiftFocus(ShiftDirection.FORWARD);
          break;
      }
    });
    return _this;
  }
  _inherits(EuiSuperSelect, _Component);
  return _createClass(EuiSuperSelect, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
      if (this.props.isOpen) {
        this.openPopover();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
    }
  }, {
    key: "focusItemAt",
    value: function focusItemAt(index, direction) {
      var _targetElement;
      var targetElement = this.itemNodes[index];
      // If the current index is disabled, find the next non-disabled element
      while (targetElement && targetElement.disabled) {
        direction === ShiftDirection.BACK ? index-- : index++;
        targetElement = this.itemNodes[index];
      }
      (_targetElement = targetElement) === null || _targetElement === void 0 || _targetElement.focus();
    }
  }, {
    key: "shiftFocus",
    value: function shiftFocus(direction) {
      var currentIndex = this.itemNodes.indexOf(document.activeElement);
      var targetElementIndex;
      if (currentIndex === -1) {
        // somehow the select options has lost focus
        targetElementIndex = 0;
      } else {
        // Note: this component purposely does not cycle arrow key navigation
        // to match native <select> elements
        if (direction === ShiftDirection.BACK) {
          targetElementIndex = currentIndex - 1;
        } else {
          targetElementIndex = currentIndex + 1;
        }
      }
      this.focusItemAt(targetElementIndex, direction);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        className = _this$props.className,
        options = _this$props.options,
        valueOfSelected = _this$props.valueOfSelected,
        placeholder = _this$props.placeholder,
        onChange = _this$props.onChange,
        isOpen = _this$props.isOpen,
        isInvalid = _this$props.isInvalid,
        hasDividers = _this$props.hasDividers,
        itemClassName = _this$props.itemClassName,
        itemLayoutAlign = _this$props.itemLayoutAlign,
        fullWidth = _this$props.fullWidth,
        popoverProps = _this$props.popoverProps,
        compressed = _this$props.compressed,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var popoverClasses = classNames('euiSuperSelect', popoverProps === null || popoverProps === void 0 ? void 0 : popoverProps.className);
      var button = ___EmotionJSX(EuiSuperSelectControl, _extends({
        options: options,
        value: valueOfSelected,
        placeholder: placeholder,
        onClick: this.state.isPopoverOpen ? this.closePopover : this.openPopover,
        onKeyDown: this.onSelectKeyDown,
        className: className,
        fullWidth: fullWidth,
        isInvalid: isInvalid,
        compressed: compressed
      }, rest, {
        buttonRef: this.controlButtonRef,
        isDropdownOpen: this.state.isPopoverOpen
      }));
      var items = options.map(function (option, index) {
        var value = option.value,
          dropdownDisplay = option.dropdownDisplay,
          inputDisplay = option.inputDisplay,
          optionRest = _objectWithoutProperties(option, _excluded2);
        if (value == null) return;
        return ___EmotionJSX(EuiSuperSelectItem, _extends({
          key: index,
          id: String(value),
          className: itemClassName,
          hasDividers: hasDividers,
          layoutAlign: itemLayoutAlign,
          icon: valueOfSelected === value ? 'check' : 'empty',
          onClick: function onClick() {
            return _this2.itemClicked(value);
          },
          onKeyDown: _this2.onItemKeyDown,
          buttonRef: function buttonRef(node) {
            return _this2.setItemNode(node, index);
          },
          "aria-selected": valueOfSelected === value
        }, optionRest), dropdownDisplay || inputDisplay);
      });
      return ___EmotionJSX(EuiInputPopover, _extends({
        closePopover: this.closePopover,
        panelPaddingSize: "none"
      }, popoverProps, {
        className: popoverClasses,
        isOpen: isOpen || this.state.isPopoverOpen,
        input: button,
        fullWidth: fullWidth,
        disableFocusTrap: true // This component handles its own focus manually
      }), ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", {
        id: this.describedById
      }, ___EmotionJSX(EuiI18n, {
        token: "euiSuperSelect.screenReaderAnnouncement",
        default: "You are in a form selector and must select a single option. Use the Up and Down arrow keys to navigate or Escape to close."
      }))), ___EmotionJSX(EuiI18n, {
        token: "euiSuperSelect.ariaLabel",
        default: "Select listbox"
      }, function (ariaLabel) {
        return ___EmotionJSX("div", {
          "aria-label": ariaLabel,
          "aria-describedby": _this2.describedById,
          css: styles.euiSuperSelect__listbox,
          className: "euiSuperSelect__listbox eui-scrollBar",
          role: "listbox",
          "aria-activedescendant": valueOfSelected != null ? String(valueOfSelected) : undefined,
          tabIndex: 0
        }, items);
      }));
    }
  }]);
}(Component);
_defineProperty(EuiSuperSelect, "defaultProps", {
  hasDividers: false,
  fullWidth: false,
  compressed: false,
  isInvalid: false,
  isLoading: false
});