import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "hasDividers"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiContextMenuItem } from '../../context_menu';
import { euiSuperSelectItemStyles } from './super_select.styles';

// Type exposed to consumers via API

// Actual props used by below component, transmogged by parent EuiSuperSelect
// from consumer props to internal EUI props
import { jsx as ___EmotionJSX } from "@emotion/react";
// Internal subcomponent util, primarily for easier usage of hooks
export var EuiSuperSelectItem = function EuiSuperSelectItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    hasDividers = _ref.hasDividers,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiSuperSelect__item', className);
  var styles = useEuiMemoizedStyles(euiSuperSelectItemStyles);
  var cssStyles = [styles.euiSuperSelect__item, hasDividers && styles.hasDividers];
  return ___EmotionJSX(EuiContextMenuItem, _extends({
    css: cssStyles,
    className: classes,
    role: "option"
  }, rest), children);
};