import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />

import React, { useState } from 'react';
import { EuiSwitch } from './switch';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Switch = function Switch() {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    checked = _useState2[0],
    setChecked = _useState2[1];
  return ___EmotionJSX(EuiSwitch, {
    label: "Malware protection",
    checked: checked,
    onChange: function onChange(e) {
      return setChecked(e.target.checked);
    }
  });
};
describe('EuiSwitch', function () {
  beforeEach(function () {
    cy.realMount(___EmotionJSX(Switch, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('Has zero violations after toggling switch', function () {
      cy.realPress('Tab');
      cy.get('button[role="switch"]').should('have.focus').invoke('attr', 'aria-checked').should('equal', 'false');
      cy.realPress('Enter');
      cy.get('button[role="switch"]').should('have.focus').invoke('attr', 'aria-checked').should('equal', 'true');
      cy.checkAxe();
    });
  });
});