import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["label", "id", "checked", "disabled", "compressed", "mini", "onChange", "className", "showLabel", "type", "labelProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback } from 'react';
import classNames from 'classnames';
import { useGeneratedHtmlId, useEuiMemoizedStyles } from '../../../services';
import { EuiIcon } from '../../icon';
import { euiSwitchStyles } from './switch.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSwitch = function EuiSwitch(_ref) {
  var label = _ref.label,
    id = _ref.id,
    checked = _ref.checked,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    mini = _ref.mini,
    onChange = _ref.onChange,
    className = _ref.className,
    _ref$showLabel = _ref.showLabel,
    showLabel = _ref$showLabel === void 0 ? true : _ref$showLabel,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    labelProps = _ref.labelProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var switchId = useGeneratedHtmlId({
    conditionalId: id
  });
  var labelId = useGeneratedHtmlId({
    conditionalId: labelProps === null || labelProps === void 0 ? void 0 : labelProps.id
  });
  var onClick = useCallback(function (e) {
    if (disabled) {
      return;
    }
    var event = e;
    event.target.checked = !checked;
    onChange(event);
  }, [checked, disabled, onChange]);
  var classes = classNames('euiSwitch', className);
  var labelClasses = classNames('euiSwitch__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  if (showLabel === false && typeof label !== 'string') {
    console.warn('EuiSwitch `label` must be a string when `showLabel` is false.');
  }
  var size = mini ? 'mini' : compressed ? 'compressed' : 'uncompressed';
  var styles = useEuiMemoizedStyles(euiSwitchStyles);
  var cssStyles = [styles.euiSwitch, disabled ? styles.disabled : styles.enabled];
  var buttonStyles = [styles.button.euiSwitch__button, styles.button[size]];
  var bodyStyles = [styles.body.euiSwitch__body, disabled ? styles.body.disabled[size] : checked ? styles.body.on : styles.body.off];
  var iconsStyles = [styles.icons.euiSwitch__icons, checked ? styles.icons.on : styles.icons.off, disabled ? styles.icons.disabled : styles.icons.enabled];
  var thumbStyles = [styles.thumb.euiSwitch__thumb, checked ? styles.thumb.on[size] : styles.thumb.off].concat(_toConsumableArray(disabled ? [styles.thumb.disabled.disabled, styles.thumb.disabled[size]] : [styles.thumb.enabled.enabled, styles.thumb.enabled[size]]));
  var labelStyles = [styles.label.euiSwitch__label, styles.label[size], disabled && styles.label.disabled, labelProps === null || labelProps === void 0 ? void 0 : labelProps.css];
  return ___EmotionJSX("div", {
    css: cssStyles,
    className: classes
  }, ___EmotionJSX("button", _extends({
    id: switchId,
    "aria-checked": checked || false,
    css: buttonStyles,
    className: "euiSwitch__button",
    role: "switch",
    type: type,
    disabled: disabled,
    onClick: onClick,
    "aria-label": showLabel ? undefined : label,
    "aria-labelledby": showLabel ? labelId : undefined
  }, rest), ___EmotionJSX("span", {
    css: bodyStyles,
    className: "euiSwitch__body"
  }, !(compressed || mini) && ___EmotionJSX("span", {
    css: iconsStyles,
    className: "euiSwitch__icons"
  }, ___EmotionJSX(EuiIcon, {
    type: "check",
    size: "m"
  }), ___EmotionJSX(EuiIcon, {
    type: "cross",
    size: "m"
  }))), ___EmotionJSX("span", {
    css: thumbStyles,
    className: "euiSwitch__thumb"
  })), showLabel &&
  // <button> + <label> has poor screen reader support.
  // Click handler added to simulate natural, secondary <label> interactivity.
  // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
  ___EmotionJSX("span", _extends({}, labelProps, {
    css: labelStyles,
    className: labelClasses,
    id: labelId,
    onClick: onClick
  }), label));
};