function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { tint } from '../../../services';
import { euiCanAnimate, euiFocusRing, euiFontSize, logicalCSS, logicalSizeCSS, mathWithUnits } from '../../../global_styling';
import { euiFormCustomControlVariables } from '../form.styles';
var euiSwitchVars = function euiSwitchVars(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var formVars = euiFormCustomControlVariables(euiThemeContext);
  var colors = {
    on: formVars.colors.selected,
    off: formVars.colors.unselectedBorder,
    disabled: formVars.colors.disabled,
    thumb: formVars.colors.selectedIcon,
    thumbBorder: formVars.colors.unselectedBorder,
    thumbBorderDisabled: formVars.colors.unselectedBorder
  };
  var sizes = {
    uncompressed: {
      height: mathWithUnits(euiTheme.size.base, function (x) {
        return x * 1.25;
      }),
      width: mathWithUnits([euiTheme.size.xxl, euiTheme.size.xs], function (x, y) {
        return x + y;
      }),
      thumbScales: {
        default: 1,
        hover: 1.05,
        active: 0.9
      }
    },
    compressed: {
      height: euiTheme.size.base,
      width: mathWithUnits(euiTheme.size.base, function (x) {
        return x * 1.75;
      }),
      thumbScales: {
        default: 0.9,
        hover: 0.95,
        active: 0.8
      }
    },
    get mini() {
      return {
        height: mathWithUnits(this.uncompressed.height, function (x) {
          return x / 2;
        }),
        width: mathWithUnits(this.uncompressed.width, function (x) {
          return x / 2;
        }),
        thumbScales: {
          default: 0.8,
          hover: undefined,
          active: undefined
        }
      };
    }
  };
  var animation = {
    speed: euiTheme.animation.normal,
    easing: euiTheme.animation.bounce
  };
  var label = {
    disabled: formVars.colors.disabledLabel,
    gap: formVars.sizes.labelGap
  };
  return {
    sizes: sizes,
    colors: colors,
    animation: animation,
    label: label
  };
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "b86pnw-disabled",
  styles: "cursor:not-allowed;label:disabled;"
} : {
  name: "b86pnw-disabled",
  styles: "cursor:not-allowed;label:disabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "eg68pp-euiSwitch",
  styles: "position:relative;display:inline-flex;align-items:flex-start;/* Required for inline-flex CSS to not render an extra 2-3px of strut height\n       * @see https://stackoverflow.com/a/27536461/4294462 */vertical-align:middle;label:euiSwitch;"
} : {
  name: "eg68pp-euiSwitch",
  styles: "position:relative;display:inline-flex;align-items:flex-start;/* Required for inline-flex CSS to not render an extra 2-3px of strut height\n       * @see https://stackoverflow.com/a/27536461/4294462 */vertical-align:middle;label:euiSwitch;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiSwitchStyles = function euiSwitchStyles(euiThemeContext) {
  var switchVars = euiSwitchVars(euiThemeContext);
  return {
    euiSwitch: _ref3,
    // Skip css`` to avoid generating an extra Emotion className
    enabled: "\n      cursor: pointer;\n    ",
    disabled: _ref2,
    button: buttonStyles(euiThemeContext, switchVars),
    // The track body must be separate from the button wrapper, because the
    // icons have their overflow hidden outside the button, but the thumb doesn't
    body: bodyStyles(euiThemeContext, switchVars),
    icons: iconStyles(euiThemeContext, switchVars),
    thumb: thumbStyles(euiThemeContext, switchVars),
    label: labelStyles(euiThemeContext, switchVars)
  };
};
var buttonStyles = function buttonStyles(euiThemeContext, switchVars) {
  var _switchVars$sizes = switchVars.sizes,
    uncompressed = _switchVars$sizes.uncompressed,
    compressed = _switchVars$sizes.compressed,
    mini = _switchVars$sizes.mini;
  return {
    euiSwitch__button: /*#__PURE__*/css("flex-shrink:0;line-height:0;position:relative;cursor:inherit;", euiFocusRing(euiThemeContext, 'outset'), ";;label:euiSwitch__button;"),
    // Skip css`` to avoid generating an Emotion className
    uncompressed: "\n      ".concat(logicalSizeCSS(uncompressed.width, uncompressed.height), "\n      border-radius: ").concat(uncompressed.height, ";\n    "),
    compressed: /*#__PURE__*/css(logicalSizeCSS(compressed.width, compressed.height), " border-radius:", compressed.height, ";;label:compressed;"),
    mini: /*#__PURE__*/css(logicalSizeCSS(mini.width, mini.height), " border-radius:", mini.height, ";;label:mini;")
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "19cwu6v-euiSwitch__body",
  styles: "position:absolute;inset:0;overflow:hidden;border-radius:inherit;pointer-events:none;label:euiSwitch__body;"
} : {
  name: "19cwu6v-euiSwitch__body",
  styles: "position:absolute;inset:0;overflow:hidden;border-radius:inherit;pointer-events:none;label:euiSwitch__body;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var bodyStyles = function bodyStyles(_ref4, _ref5) {
  var colorMode = _ref4.colorMode;
  var colors = _ref5.colors;
  // This is probably very extra, but the visual weight of the default
  // disabled custom control feels different in light mode depending
  // on the size of the switch, so I'm tinting it based on that.
  // Gotta justify my stupidly expensive art degree!
  var _calculateDisabledColor = function _calculateDisabledColor(tintAmount) {
    return /*#__PURE__*/css("label:disabled;background-color:", colorMode === 'DARK' ? colors.disabled : tint(colors.disabled, tintAmount), ";");
  };
  return {
    euiSwitch__body: _ref,
    on: /*#__PURE__*/css("background-color:", colors.on, ";;label:on;"),
    off: /*#__PURE__*/css("background-color:", colors.off, ";;label:off;"),
    disabled: {
      uncompressed: _calculateDisabledColor(0.5),
      compressed: _calculateDisabledColor(0.25),
      mini: _calculateDisabledColor(0)
    }
  };
};
var iconStyles = function iconStyles(_ref6, _ref7) {
  var euiTheme = _ref6.euiTheme;
  var colors = _ref7.colors,
    animation = _ref7.animation;
  return {
    euiSwitch__icons: /*#__PURE__*/css("position:absolute;", logicalCSS('vertical', 0), " ", logicalCSS('left', '-50%'), " ", logicalCSS('width', '200%'), " display:flex;justify-content:space-around;align-items:center;", logicalCSS('padding-horizontal', euiTheme.size.xs), " ", euiCanAnimate, "{transition-property:inset-inline-start;transition-duration:", animation.speed, ";transition-timing-function:", animation.easing, ";};label:euiSwitch__icons;"),
    on: /*#__PURE__*/css(logicalCSS('left', '-25%'), ";;label:on;"),
    off: /*#__PURE__*/css(logicalCSS('left', '-75%'), ";;label:off;"),
    enabled: /*#__PURE__*/css("color:", colors.thumb, ";;label:enabled;"),
    disabled: /*#__PURE__*/css("color:", colors.thumbBorderDisabled, ";;label:disabled;")
  };
};
var thumbStyles = function thumbStyles(_ref8, switchVars) {
  var euiTheme = _ref8.euiTheme;
  var sizes = switchVars.sizes,
    colors = switchVars.colors,
    animation = switchVars.animation;
  var uncompressed = sizes.uncompressed,
    compressed = sizes.compressed,
    mini = sizes.mini;
  var _calculateScale = function _calculateScale(size, hoverActiveStates) {
    var baseScale = "transform: scale(".concat(sizes[size].thumbScales.default, ");");
    var states = hoverActiveStates ? "\n      .euiSwitch:hover & {\n        transform: scale(".concat(sizes[size].thumbScales.hover, ");\n      }\n      .euiSwitch:active & {\n        transform: scale(").concat(sizes[size].thumbScales.active, ");\n      }") : '';
    return "".concat(baseScale).concat(states);
  };
  return {
    euiSwitch__thumb: /*#__PURE__*/css("position:absolute;", logicalCSS('vertical', 0), " aspect-ratio:1;", logicalCSS('width', 'fit-content'), " ", logicalCSS('height', '100%'), " border-radius:50%;pointer-events:none;", euiCanAnimate, "{transition-property:inset-inline-start,transform,background-color,border-color;transition-duration:", animation.speed, ";transition-timing-function:", animation.easing, ";};label:euiSwitch__thumb;"),
    off: /*#__PURE__*/css(logicalCSS('left', 0), ";;label:off;"),
    get on() {
      // right: 0 works but doesn't transition/animate, so we need to
      // manually calculate the left position per switch size
      var _calculateLeft = function _calculateLeft(bodyWidth, thumbWidth) {
        var leftPosition = mathWithUnits([bodyWidth, thumbWidth], function (x, y) {
          return x - y;
        });
        return /*#__PURE__*/css("label:on;", logicalCSS('left', leftPosition), ";");
      };
      return {
        uncompressed: _calculateLeft(uncompressed.width, uncompressed.height),
        compressed: _calculateLeft(compressed.width, compressed.height),
        mini: _calculateLeft(mini.width, mini.height)
      };
    },
    enabled: {
      enabled: "\n        background-color: ".concat(colors.thumb, ";\n        border: ").concat(euiTheme.border.width.thin, " solid ").concat(colors.thumbBorder, ";\n      "),
      uncompressed: _calculateScale('uncompressed', true),
      compressed: _calculateScale('compressed', true),
      mini: _calculateScale('mini', false)
    },
    disabled: {
      disabled: /*#__PURE__*/css("background-color:transparent;border:", euiTheme.border.width.thin, " solid ", colors.thumbBorderDisabled, ";;label:disabled;"),
      uncompressed: _calculateScale('uncompressed', false),
      compressed: _calculateScale('compressed', false),
      mini: _calculateScale('mini', false)
    }
  };
};
var labelStyles = function labelStyles(euiThemeContext, _ref9) {
  var sizes = _ref9.sizes,
    label = _ref9.label;
  var uncompressed = sizes.uncompressed,
    compressed = sizes.compressed,
    mini = sizes.mini;
  return {
    euiSwitch__label: /*#__PURE__*/css(logicalCSS('padding-left', label.gap), ";;label:euiSwitch__label;"),
    // Skip css`` to avoid generating an Emotion className
    uncompressed: "\n      font-size: ".concat(euiFontSize(euiThemeContext, 's').fontSize, ";\n      line-height: ").concat(uncompressed.height, ";\n    "),
    compressed: /*#__PURE__*/css("font-size:", euiFontSize(euiThemeContext, 's').fontSize, ";line-height:", compressed.height, ";;label:compressed;"),
    mini: /*#__PURE__*/css("font-size:", euiFontSize(euiThemeContext, 'xs').fontSize, ";line-height:", mini.height, ";;label:mini;"),
    disabled: /*#__PURE__*/css("color:", label.disabled, ";;label:disabled;")
  };
};