import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "compressed", "fullWidth", "id", "icon", "inputRef", "isLoading", "isInvalid", "isClearable", "name", "placeholder", "resize", "rows"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useRef, useMemo } from 'react';
import classNames from 'classnames';
import { useCombinedRefs, useEuiMemoizedStyles } from '../../../services';
import { EuiFormControlLayout } from '../form_control_layout';
import { EuiValidatableControl } from '../validatable_control';
import { useFormContext } from '../eui_form_context';
import { euiTextAreaStyles } from './text_area.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var RESIZE = ['vertical', 'horizontal', 'both', 'none'];
export var EuiTextArea = function EuiTextArea(props) {
  var _useFormContext = useFormContext(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var children = props.children,
    className = props.className,
    compressed = props.compressed,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    id = props.id,
    icon = props.icon,
    inputRef = props.inputRef,
    isLoading = props.isLoading,
    isInvalid = props.isInvalid,
    isClearable = props.isClearable,
    name = props.name,
    placeholder = props.placeholder,
    _props$resize = props.resize,
    resize = _props$resize === void 0 ? 'vertical' : _props$resize,
    rows = props.rows,
    rest = _objectWithoutProperties(props, _excluded);
  var classes = classNames('euiTextArea', className);
  var styles = useEuiMemoizedStyles(euiTextAreaStyles);
  var cssStyles = [styles.euiTextArea, styles.resize[resize], compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth];
  var ref = useRef(null);
  var refs = useCombinedRefs([ref, inputRef]);
  var clear = useMemo(function () {
    if (isClearable) {
      return {
        onClick: function onClick() {
          if (ref.current) {
            // Updates the displayed value and fires `onChange` callbacks
            // @see https://stackoverflow.com/questions/23892547/what-is-the-best-way-to-trigger-onchange-event-in-react-js
            var nativeValueSetter = Object.getOwnPropertyDescriptor(window.HTMLTextAreaElement.prototype, 'value').set;
            nativeValueSetter.call(ref.current, '');
            var event = new Event('input', {
              bubbles: true,
              cancelable: false
            });
            ref.current.dispatchEvent(event);

            // Set focus back to the textarea
            ref.current.focus();
          }
        },
        'data-test-subj': 'clearTextAreaButton'
      };
    }
  }, [isClearable]);
  return ___EmotionJSX(EuiFormControlLayout, {
    fullWidth: fullWidth,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDisabled: rest.disabled,
    clear: clear,
    icon: icon,
    className: "euiFormControlLayout--euiTextArea",
    css: styles.formControlLayout.euiTextArea
  }, ___EmotionJSX(EuiValidatableControl, {
    isInvalid: isInvalid
  }, ___EmotionJSX("textarea", _extends({
    className: classes,
    css: cssStyles
  }, rest, {
    rows: rows ? rows : compressed ? 3 : 6,
    name: name,
    id: id,
    ref: refs,
    placeholder: placeholder
  }), children)));
};