function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../../global_styling';
import { euiFormControlStyles, euiFormVariables } from '../form.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1kbjxwy-none",
  styles: "resize:none;label:none;"
} : {
  name: "1kbjxwy-none",
  styles: "resize:none;label:none;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "wm6f07-both",
  styles: "resize:both;label:both;"
} : {
  name: "wm6f07-both",
  styles: "resize:both;label:both;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1b1o46o-horizontal",
  styles: "resize:horizontal;label:horizontal;"
} : {
  name: "1b1o46o-horizontal",
  styles: "resize:horizontal;label:horizontal;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "1x2zvot-vertical",
  styles: "resize:vertical;label:vertical;"
} : {
  name: "1x2zvot-vertical",
  styles: "resize:vertical;label:vertical;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiTextAreaStyles = function euiTextAreaStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var formStyles = euiFormControlStyles(euiThemeContext);
  var formVars = euiFormVariables(euiThemeContext);
  return {
    euiTextArea: /*#__PURE__*/css(formStyles.shared, "line-height:", euiTheme.font.lineHeightMultiplier, ";/* <textarea>s default to 'inline-block', which causes an extra 2-3px of\n       * unnecessary height within its parent 'block' form control wrapper.\n       * @see https://stackoverflow.com/a/27536461/4294462 */display:block;&:invalid{", formStyles.invalid, ";}&:focus{", formStyles.focus, ";}&:disabled{", formStyles.disabled, ";}&[readOnly]{", formStyles.readOnly, ";}&:autofill{", formStyles.autoFill, ";};label:euiTextArea;"),
    resize: {
      vertical: _ref4,
      horizontal: _ref3,
      both: _ref2,
      none: _ref
    },
    // Skip the css() on the default height to avoid generating a className
    uncompressed: "\n      ".concat(logicalCSS('height', 'auto'), "\n      padding: ").concat(formVars.controlPadding, ";\n      border-radius: ").concat(formVars.controlBorderRadius, ";\n    "),
    compressed: /*#__PURE__*/css(logicalCSS('height', 'auto'), " padding:", formVars.controlCompressedPadding, ";border-radius:", formVars.controlCompressedBorderRadius, ";;label:compressed;"),
    // Skip the css() on the default width to avoid generating a className
    formWidth: formStyles.formWidth,
    fullWidth: /*#__PURE__*/css(formStyles.fullWidth, ";label:fullWidth;"),
    // EuiFormControlLayout styles
    formControlLayout: {
      euiTextArea: /*#__PURE__*/css(logicalCSS('height', 'auto'), " .euiFormControlLayoutIcons{", logicalCSS('top', 'auto'), " ", logicalCSS('bottom', formVars.controlPadding), ";};label:euiTextArea;")
    }
  };
};