import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiAvatar } from '../avatar';
import { EuiFlexGroup, EuiFlexItem } from '../flex';
import { EuiHeaderBreadcrumbs } from './header_breadcrumbs';
import { EuiHeader } from './header';
import { EuiHeaderLogo } from './header_logo';
import { EuiHeaderSectionItemButton, EuiHeaderSectionItem, EuiHeaderSection } from './header_section';
import { EuiIcon } from '../icon';
import { EuiKeyPadMenu, EuiKeyPadMenuItem } from '../key_pad_menu';
import { EuiLink } from '../link';
import { EuiPopover, EuiPopoverTitle } from '../popover';
import { EuiSelectable, EuiSelectableMessage, EuiSelectableTemplateSitewide } from '../selectable';
import { EuiSpacer } from '../spacer';
import { EuiText } from '../text';
import { useGeneratedHtmlId } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Header = function Header() {
  var renderLogo = function renderLogo() {
    return ___EmotionJSX(EuiHeaderLogo, {
      iconType: "logoElastic",
      href: "#",
      onClick: function onClick(e) {
        return e.preventDefault();
      },
      "aria-label": "Go to home page"
    });
  };
  var renderBreadcrumbs = function renderBreadcrumbs() {
    var breadcrumbs = [{
      text: 'Management',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      },
      'data-test-subj': 'breadcrumbsAnimals',
      className: 'customClass'
    }, {
      text: 'Truncation test is here for a really long item',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      }
    }, {
      text: 'Hidden',
      'data-test-subj': 'cy-breadcrumb-hidden',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      }
    }, {
      text: 'Users',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      }
    }, {
      text: 'Create'
    }];
    return ___EmotionJSX(EuiHeaderBreadcrumbs, {
      "aria-label": "Header breadcrumbs example",
      breadcrumbs: breadcrumbs
    });
  };
  var search = ___EmotionJSX(EuiSelectableTemplateSitewide, {
    options: [],
    searchProps: {
      compressed: true
    },
    popoverButton: ___EmotionJSX(EuiHeaderSectionItemButton, {
      "aria-label": "Sitewide search"
    }, ___EmotionJSX(EuiIcon, {
      type: "search",
      size: "m"
    })),
    emptyMessage: ___EmotionJSX(EuiSelectableMessage, {
      style: {
        minHeight: 300
      },
      "data-test-subj": "cy-search-menu"
    }, ___EmotionJSX("p", null, "Please see the component page for", ' ', ___EmotionJSX("strong", null, "EuiSelectableTemplateSitewide"), "on how to configure your sitewide search."))
  });
  return ___EmotionJSX(EuiHeader, null, ___EmotionJSX(EuiHeaderSection, {
    grow: false
  }, ___EmotionJSX(EuiHeaderSectionItem, null, renderLogo()), ___EmotionJSX(EuiHeaderSectionItem, null, ___EmotionJSX(HeaderSpacesMenu, null))), renderBreadcrumbs(), ___EmotionJSX(EuiHeaderSection, {
    side: "right"
  }, ___EmotionJSX(EuiHeaderSectionItem, null, search), ___EmotionJSX(EuiHeaderSectionItem, null, ___EmotionJSX(HeaderUserMenu, null)), ___EmotionJSX(EuiHeaderSectionItem, null, ___EmotionJSX(HeaderAppMenu, null))));
};
var HeaderUserMenu = function HeaderUserMenu() {
  var headerUserPopoverId = useGeneratedHtmlId({
    prefix: 'headerUserPopover'
  });
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var onMenuButtonClick = function onMenuButtonClick() {
    setIsOpen(!isOpen);
  };
  var closeMenu = function closeMenu() {
    setIsOpen(false);
  };
  var button = ___EmotionJSX(EuiHeaderSectionItemButton, {
    "aria-controls": headerUserPopoverId,
    "aria-expanded": isOpen,
    "aria-haspopup": "true",
    "aria-label": "Account menu",
    onClick: onMenuButtonClick
  }, ___EmotionJSX(EuiAvatar, {
    name: "John Username",
    size: "s"
  }));
  return ___EmotionJSX(EuiPopover, {
    id: headerUserPopoverId,
    button: button,
    isOpen: isOpen,
    anchorPosition: "downRight",
    closePopover: closeMenu,
    panelPaddingSize: "none",
    "data-test-subj": "cy-account-menu"
  }, ___EmotionJSX("div", {
    style: {
      width: 320
    }
  }, ___EmotionJSX(EuiFlexGroup, {
    gutterSize: "m",
    className: "euiHeaderProfile",
    responsive: false
  }, ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(EuiAvatar, {
    name: "John Username",
    size: "xl"
  })), ___EmotionJSX(EuiFlexItem, null, ___EmotionJSX(EuiText, null, ___EmotionJSX("p", null, "John Username")), ___EmotionJSX(EuiSpacer, {
    size: "m"
  }), ___EmotionJSX(EuiFlexGroup, null, ___EmotionJSX(EuiFlexItem, null, ___EmotionJSX(EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(EuiLink, null, "Edit profile")), ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(EuiLink, null, "Log out")))))))));
};
var HeaderSpacesMenu = function HeaderSpacesMenu() {
  var headerSpacesPopoverId = useGeneratedHtmlId({
    prefix: 'headerSpacesPopover'
  });
  var spacesValues = [{
    label: 'Sales team',
    prepend: ___EmotionJSX(EuiAvatar, {
      type: "space",
      name: "Sales Team",
      size: "s"
    }),
    checked: 'on'
  }, {
    label: 'Engineering',
    prepend: ___EmotionJSX(EuiAvatar, {
      type: "space",
      name: "Engineering",
      size: "s"
    })
  }];
  var _useState3 = useState(spacesValues),
    _useState4 = _slicedToArray(_useState3, 2),
    spaces = _useState4[0],
    setSpaces = _useState4[1];
  var _useState5 = useState(spaces.filter(function (option) {
      return option.checked;
    })[0]),
    _useState6 = _slicedToArray(_useState5, 2),
    selectedSpace = _useState6[0],
    setSelectedSpace = _useState6[1];
  var _useState7 = useState(false),
    _useState8 = _slicedToArray(_useState7, 2),
    isOpen = _useState8[0],
    setIsOpen = _useState8[1];
  var isListExtended = function isListExtended() {
    return spaces.length > 4 ? true : false;
  };
  var onMenuButtonClick = function onMenuButtonClick() {
    setIsOpen(!isOpen);
  };
  var closePopover = function closePopover() {
    setIsOpen(false);
  };
  var onChange = function onChange(options) {
    setSpaces(options);
    setSelectedSpace(options.filter(function (option) {
      return option.checked;
    })[0]);
    setIsOpen(false);
  };
  var button = ___EmotionJSX(EuiHeaderSectionItemButton, {
    "aria-controls": headerSpacesPopoverId,
    "aria-expanded": isOpen,
    "aria-haspopup": "true",
    "aria-label": "Spaces menu",
    onClick: onMenuButtonClick
  }, selectedSpace.prepend);
  return ___EmotionJSX(EuiPopover, {
    id: headerSpacesPopoverId,
    button: button,
    isOpen: isOpen,
    anchorPosition: "downLeft",
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, ___EmotionJSX(EuiSelectable, {
    searchable: isListExtended(),
    searchProps: {
      placeholder: 'Find a space',
      compressed: true
    },
    options: spaces,
    singleSelection: "always",
    style: {
      width: 300
    },
    onChange: onChange,
    listProps: {
      rowHeight: 40,
      showIcons: false
    },
    "data-test-subj": "cy-spaces-menu"
  }, function (list, search) {
    return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiPopoverTitle, {
      paddingSize: "s"
    }, search || 'Your spaces'), list);
  }));
};
var HeaderAppMenu = function HeaderAppMenu() {
  var headerAppPopoverId = useGeneratedHtmlId({
    prefix: 'headerAppPopover'
  });
  var headerAppKeyPadMenuId = useGeneratedHtmlId({
    prefix: 'headerAppKeyPadMenu'
  });
  var _useState9 = useState(false),
    _useState10 = _slicedToArray(_useState9, 2),
    isOpen = _useState10[0],
    setIsOpen = _useState10[1];
  var onMenuButtonClick = function onMenuButtonClick() {
    setIsOpen(!isOpen);
  };
  var closeMenu = function closeMenu() {
    setIsOpen(false);
  };
  var button = ___EmotionJSX(EuiHeaderSectionItemButton, {
    "aria-controls": headerAppKeyPadMenuId,
    "aria-expanded": isOpen,
    "aria-haspopup": "true",
    "aria-label": "Apps menu with 1 new app",
    notification: "1",
    onClick: onMenuButtonClick
  }, ___EmotionJSX(EuiIcon, {
    type: "apps",
    size: "m"
  }));
  return ___EmotionJSX(EuiPopover, {
    id: headerAppPopoverId,
    button: button,
    isOpen: isOpen,
    anchorPosition: "downRight",
    closePopover: closeMenu
  }, ___EmotionJSX(EuiKeyPadMenu, {
    id: headerAppKeyPadMenuId,
    style: {
      width: 288
    },
    "data-test-subj": "cy-apps-menu"
  }, ___EmotionJSX(EuiKeyPadMenuItem, {
    label: "Discover"
  }, ___EmotionJSX(EuiIcon, {
    type: "discoverApp",
    size: "l"
  })), ___EmotionJSX(EuiKeyPadMenuItem, {
    label: "Dashboard"
  }, ___EmotionJSX(EuiIcon, {
    type: "dashboardApp",
    size: "l"
  })), ___EmotionJSX(EuiKeyPadMenuItem, {
    label: "Dev Tools"
  }, ___EmotionJSX(EuiIcon, {
    type: "devToolsApp",
    size: "l"
  }))));
};
beforeEach(function () {
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount(___EmotionJSX(Header, null));
});
describe('EuiHeader', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when Spaces menu is expanded', function () {
      cy.get('button[aria-label="Spaces menu"]').realClick();
      cy.get('div[data-test-subj="cy-spaces-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when Account menu is expanded', function () {
      cy.get('button[aria-label="Account menu"]').realClick();
      cy.get('div[data-test-subj="cy-account-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when Sitewide search is expanded', function () {
      cy.get('button[aria-label="Sitewide search"]').realClick();
      cy.get('div[data-test-subj="cy-search-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when Apps menu is expanded', function () {
      cy.get('button[aria-label="Apps menu with 1 new app"]').realClick();
      cy.get('ul[data-test-subj="cy-apps-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when a hidden breadcrumb is expanded', function () {
      cy.get('button[title="See collapsed breadcrumbs"]').realClick();
      cy.get('a[data-test-subj="cy-breadcrumb-hidden"]').should('exist');
      cy.checkAxe();
    });
  });
});