import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "sections", "position", "theme"],
  _excluded2 = ["children", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useEffect, useState, useMemo, useCallback } from 'react';
import classNames from 'classnames';
import { useEuiTheme, useEuiThemeCSSVariables } from '../../services';
import { mathWithUnits, logicalStyles } from '../../global_styling';
import { EuiHeaderBreadcrumbs } from './header_breadcrumbs';
import { EuiHeaderSectionItem, EuiHeaderSection } from './header_section';
import { euiHeaderStyles, euiHeaderVariables } from './header.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var createHeaderSection = function createHeaderSection(sections) {
  return sections.map(function (section, index) {
    return ___EmotionJSX(EuiHeaderSectionItem, {
      key: index
    }, section);
  });
};
export var EuiHeader = function EuiHeader(_ref) {
  var children = _ref.children,
    className = _ref.className,
    sections = _ref.sections,
    _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'static' : _ref$position,
    _ref$theme = _ref.theme,
    theme = _ref$theme === void 0 ? 'default' : _ref$theme,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiHeader', className);
  var euiTheme = useEuiTheme();
  var styles = euiHeaderStyles(euiTheme);
  var cssStyles = [styles.euiHeader, styles[position], styles[theme]];
  var contents;
  if (sections) {
    if (children) {
      // In case both children and sections are passed, warn in the console that the children will be disregarded
      console.warn('EuiHeader cannot accept both `children` and `sections`. It will disregard the `children`.');
    }
    contents = sections.map(function (section, index) {
      var content = [];
      if (section.items) {
        // Items get wrapped in EuiHeaderSection and each item in a EuiHeaderSectionItem
        content.push(___EmotionJSX(EuiHeaderSection, {
          key: "items-".concat(index)
        }, createHeaderSection(section.items)));
      }
      if (section.breadcrumbs) {
        content.push(
        // Breadcrumbs are separate and cannot be contained in a EuiHeaderSection
        // in order for truncation to work
        ___EmotionJSX(EuiHeaderBreadcrumbs, _extends({
          key: "breadcrumbs-".concat(index),
          breadcrumbs: section.breadcrumbs
        }, section.breadcrumbProps)));
      }
      return content;
    });
  } else {
    contents = children;
  }
  return position === 'fixed' ? ___EmotionJSX(EuiFixedHeader, _extends({
    css: cssStyles,
    className: classes
  }, rest), contents) : ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), contents);
};

/**
 * Fixed headers - logic around dynamically calculating the total
 * page offset and setting the `top` position of subsequent headers
 */

// Start a counter to manage the total number of fixed headers
// Exported for unit testing only
export var euiFixedHeadersCount = 0;

// Exported for unit testing only
export var EuiFixedHeader = function EuiFixedHeader(_ref2) {
  var children = _ref2.children,
    style = _ref2.style,
    rest = _objectWithoutProperties(_ref2, _excluded2);
  var _useEuiThemeCSSVariab = useEuiThemeCSSVariables(),
    setGlobalCSSVariables = _useEuiThemeCSSVariab.setGlobalCSSVariables;
  var euiTheme = useEuiTheme();
  var headerHeight = euiHeaderVariables(euiTheme).height;
  var getHeaderOffset = useCallback(function () {
    return mathWithUnits(headerHeight, function (x) {
      return x * euiFixedHeadersCount;
    });
  }, [headerHeight]);
  var _useState = useState(),
    _useState2 = _slicedToArray(_useState, 2),
    topPosition = _useState2[0],
    setTopPosition = _useState2[1];
  useEffect(function () {
    // Get the top position from the offset of previous header(s)
    setTopPosition(getHeaderOffset());

    // Increment fixed header counter for each fixed header
    euiFixedHeadersCount++;
    setGlobalCSSVariables({
      '--euiFixedHeadersOffset': getHeaderOffset()
    });
    document.body.classList.add('euiBody--headerIsFixed'); // TODO: Consider deleting this legacy className

    return function () {
      euiFixedHeadersCount--;
      setGlobalCSSVariables({
        '--euiFixedHeadersOffset': getHeaderOffset()
      });
      if (euiFixedHeadersCount === 0) {
        document.body.classList.remove('euiBody--headerIsFixed'); // TODO: Consider deleting this legacy className
      }
    };
  }, [getHeaderOffset, setGlobalCSSVariables]);
  var inlineStyles = useMemo(function () {
    return logicalStyles(_objectSpread({
      top: topPosition
    }, style));
  }, [topPosition, style]);
  return ___EmotionJSX("div", _extends({
    "data-fixed-header": true // Used by EuiFlyouts as a query selector
    ,
    style: inlineStyles
  }, rest), children);
};