/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiShadowSmall } from '../../themes/amsterdam/global_styling/mixins';
import { logicalCSS } from '../../global_styling';
import { shade, transparentize, makeHighContrastColor } from '../../services';
export var euiHeaderVariables = function euiHeaderVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    height: euiTheme.size.xxxl,
    childHeight: euiTheme.size.xxl,
    padding: euiTheme.size.s
  };
};
export var euiHeaderStyles = function euiHeaderStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiHeaderVariables = euiHeaderVariables(euiThemeContext),
    height = _euiHeaderVariables.height,
    padding = _euiHeaderVariables.padding;
  return {
    euiHeader: /*#__PURE__*/css("display:flex;justify-content:space-between;", logicalCSS('height', height), " ", logicalCSS('padding-horizontal', padding), " ", logicalCSS('border-bottom', euiTheme.border.thin), " ", euiShadowSmall(euiThemeContext), ";;label:euiHeader;"),
    // Position
    static: /*#__PURE__*/css("z-index:", Number(euiTheme.levels.header) - 1, ";position:relative;;label:static;"),
    fixed: /*#__PURE__*/css("z-index:", euiTheme.levels.header, ";position:fixed;", logicalCSS('top', 0), " ", logicalCSS('horizontal', 0), ";;label:fixed;"),
    // Theme
    default: /*#__PURE__*/css("background-color:", euiTheme.colors.emptyShade, ";;label:default;"),
    dark: /*#__PURE__*/css(euiHeaderDarkStyles(euiThemeContext), ";label:dark;")
  };
};

/**
 * The `dark` header is (currently) a bit of a special case. We don't
 * actually want to use <EuiThemeProvider colorMode="dark"> inside it
 * because that will affect popovers and `SelectableSitewideTemplate`
 * as well, which we do not necessarily want to do (?)
 *
 * It's also possible that the dark header will go away or become unused
 * by Kibana in the near future, at which point we can remove this
 */
import { euiFormVariables } from '../form/form.styles';
var euiHeaderDarkStyles = function euiHeaderDarkStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var _euiFormVariables = euiFormVariables(euiThemeContext),
    controlPlaceholderText = _euiFormVariables.controlPlaceholderText;
  var backgroundColor = colorMode === 'DARK' ? shade(euiTheme.colors.lightestShade, 0.5) : shade(euiTheme.colors.darkestShade, 0.28);

  // Specific color overrides for EuiSelectableTemplateSitewide
  var selectableSitewide = {
    color: euiTheme.colors.ghost,
    borderColor: transparentize(euiTheme.colors.ghost, 0.3),
    placeholderColor: makeHighContrastColor(controlPlaceholderText, 8)(backgroundColor)
  };
  return "\n    background-color: ".concat(backgroundColor, ";\n\n    .euiHeaderLogo__text,\n    .euiHeaderLink,\n    .euiHeaderSectionItemButton {\n      color: ").concat(euiTheme.colors.ghost, ";\n    }\n\n    .euiHeaderLink-isActive {\n      color: ").concat(makeHighContrastColor(euiTheme.colors.primary)(backgroundColor), ";\n    }\n\n    .euiHeaderLogo,\n    .euiHeaderLink,\n    .euiHeaderSectionItemButton {\n      &:focus {\n        background-color: ").concat(shade(euiTheme.colors.primary, 0.5), ";\n      }\n    }\n\n    .euiHeaderSectionItemButton__notification--badge {\n      box-shadow: 0 0 0 ").concat(euiTheme.border.width.thin, " ").concat(backgroundColor, ";\n    }\n\n    .euiHeaderSectionItemButton__notification--dot {\n      stroke: ").concat(backgroundColor, ";\n    }\n\n    .euiSelectableTemplateSitewide .euiFormControlLayout {\n      background-color: transparent;\n\n      input {\n        box-shadow: inset 0 0 0 ").concat(euiTheme.border.width.thin, " ").concat(selectableSitewide.borderColor, ";\n      }\n\n      &--group {\n        border-color: ").concat(selectableSitewide.borderColor, ";\n\n        input {\n          box-shadow: none;\n        }\n      }\n\n      &:not(:focus-within) {\n        /* Increase contrast of filled text to be more than placeholder text */\n        color: ").concat(selectableSitewide.color, ";\n\n        input {\n          /* Increase contrast of placeholder text */\n          &::placeholder {\n            color: ").concat(selectableSitewide.placeholderColor, ";\n          }\n\n          /* Inherit color from form control layout */\n          color: inherit;\n          background-color: transparent;\n        }\n\n        .euiFormControlLayout__append,\n        .euiFormControlLayout__prepend {\n          background-color: transparent;\n        }\n\n        .euiFormLabel {\n          color: inherit;\n        }\n      }\n    }\n  ");
};