/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, euiFontSize } from '../../../global_styling';
import { euiTitle } from '../../title/title.styles';
export var euiHeaderAlertStyles = function euiHeaderAlertStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiHeaderAlert: /*#__PURE__*/css("position:relative;", logicalCSS('min-width', '300px'), " ", logicalCSS('padding-horizontal', euiTheme.size.s), " &:not(:last-child){", logicalCSS('margin-bottom', euiTheme.size.l), " ", logicalCSS('padding-bottom', euiTheme.size.l), " ", logicalCSS('border-bottom', euiTheme.border.thin), ";};label:euiHeaderAlert;"),
    euiHeaderAlert__title: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xs'), " ", logicalCSS('margin-bottom', euiTheme.size.s), ";;label:euiHeaderAlert__title;"),
    euiHeaderAlert__text: /*#__PURE__*/css(euiFontSize(euiThemeContext, 's'), " ", logicalCSS('margin-bottom', euiTheme.size.base), ";;label:euiHeaderAlert__text;"),
    euiHeaderAlert__action: /*#__PURE__*/css(euiFontSize(euiThemeContext, 's'), ";;label:euiHeaderAlert__action;"),
    euiHeaderAlert__date: /*#__PURE__*/css(euiFontSize(euiThemeContext, 'xs'), " color:", euiTheme.colors.darkShade, ";;label:euiHeaderAlert__date;")
  };
};