import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["isActive", "className", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { EuiButtonEmpty } from '../../button';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiHeaderLink = function EuiHeaderLink(_ref) {
  var isActive = _ref.isActive,
    className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 's' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiHeaderLink', {
    'euiHeaderLink-isActive': isActive
  }, className);
  return ___EmotionJSX(EuiButtonEmpty, _extends({
    className: classes,
    color: isActive ? 'primary' : 'text',
    size: size
  }, rest));
};