import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "gutterSize", "popoverBreakpoints", "popoverButtonProps", "popoverProps"],
  _excluded2 = ["onClick", "iconType"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useEffect, useCallback } from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { EuiIcon } from '../../icon';
import { EuiPopover } from '../../popover';
import { EuiI18n } from '../../i18n';
import { EuiHeaderSectionItemButton } from '../header_section';
import { EuiHideFor, EuiShowFor } from '../../responsive';
import { euiHeaderLinksStyles } from './header_links.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var GUTTER_SIZES = ['xxs', 'xs', 's', 'm', 'l'];
export var EuiHeaderLinks = function EuiHeaderLinks(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 's' : _ref$gutterSize,
    _ref$popoverBreakpoin = _ref.popoverBreakpoints,
    popoverBreakpoints = _ref$popoverBreakpoin === void 0 ? ['xs', 's'] : _ref$popoverBreakpoin,
    popoverButtonProps = _ref.popoverButtonProps,
    popoverProps = _ref.popoverProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = useEuiTheme();
  var styles = euiHeaderLinksStyles(euiTheme);
  var _ref2 = popoverButtonProps || {},
    onClick = _ref2.onClick,
    _ref2$iconType = _ref2.iconType,
    iconType = _ref2$iconType === void 0 ? 'apps' : _ref2$iconType,
    popoverButtonRest = _objectWithoutProperties(_ref2, _excluded2);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    mobileMenuIsOpen = _useState2[0],
    setMobileMenuIsOpen = _useState2[1];
  var onMenuButtonClick = useCallback(function (e) {
    onClick === null || onClick === void 0 || onClick(e);
    setMobileMenuIsOpen(function (mobileMenuIsOpen) {
      return !mobileMenuIsOpen;
    });
  }, [onClick]);
  var closeMenu = useCallback(function () {
    setMobileMenuIsOpen(false);
  }, []);
  useEffect(function () {
    window.addEventListener('resize', closeMenu);
    return function () {
      window.removeEventListener('resize', closeMenu);
    };
  }, [closeMenu]);
  var classes = classNames('euiHeaderLinks', className);
  var button = ___EmotionJSX(EuiI18n, {
    token: "euiHeaderLinks.openNavigationMenu",
    default: "Open menu"
  }, function (openNavigationMenu) {
    return ___EmotionJSX(EuiHeaderSectionItemButton, _extends({
      "aria-label": openNavigationMenu,
      onClick: onMenuButtonClick
    }, popoverButtonRest), ___EmotionJSX(EuiIcon, {
      type: iconType,
      size: "m"
    }));
  });
  var renderedChildren = typeof children === 'function' ? children(closeMenu) : children;
  return ___EmotionJSX(EuiI18n, {
    token: "euiHeaderLinks.appNavigation",
    default: "App menu"
  }, function (appNavigation) {
    return ___EmotionJSX("nav", _extends({
      className: classes,
      css: styles.euiHeaderLinks,
      "aria-label": appNavigation
    }, rest), ___EmotionJSX(EuiHideFor, {
      sizes: popoverBreakpoints
    }, ___EmotionJSX("div", {
      className: "euiHeaderLinks__list",
      css: [styles.euiHeaderLinks__list, styles.gutterSizes[gutterSize], ";label:EuiHeaderLinks;"]
    }, renderedChildren)), ___EmotionJSX(EuiShowFor, {
      sizes: popoverBreakpoints
    }, ___EmotionJSX(EuiPopover, _extends({
      button: button,
      isOpen: mobileMenuIsOpen,
      anchorPosition: "downRight",
      closePopover: closeMenu,
      panelPaddingSize: "s",
      repositionOnScroll: true
    }, popoverProps), ___EmotionJSX("div", {
      className: "euiHeaderLinks__mobileList",
      css: styles.euiHeaderLinks__mobileList
    }, renderedChildren))));
  });
};