/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, euiBreakpoint } from '../../../global_styling';
import { euiTitle } from '../../title/title.styles';
import { euiHeaderVariables } from '../header.styles';
export var euiHeaderLogoStyles = function euiHeaderLogoStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiHeaderVariables = euiHeaderVariables(euiThemeContext),
    childHeight = _euiHeaderVariables.childHeight;
  return {
    euiHeaderLogo: /*#__PURE__*/css("position:relative;", logicalCSS('height', childHeight), " line-height:", childHeight, ";", logicalCSS('min-width', childHeight), " padding-inline:", euiTheme.size.s, ";display:inline-flex;align-items:center;white-space:nowrap;", euiBreakpoint(euiThemeContext, ['xs']), "{", logicalCSS('padding-left', euiTheme.size.xs), ";};label:euiHeaderLogo;"),
    euiHeaderLogo__text: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xxs'), " ", logicalCSS('padding-left', euiTheme.size.base), " ", euiBreakpoint(euiThemeContext, ['xs']), "{", logicalCSS('padding-left', euiTheme.size.s), ";};label:euiHeaderLogo__text;")
  };
};