import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["side", "children", "className", "grow"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { euiHeaderSectionStyles } from './header_section.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiHeaderSection = function EuiHeaderSection(_ref) {
  var side = _ref.side,
    children = _ref.children,
    className = _ref.className,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? false : _ref$grow,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = euiHeaderSectionStyles();
  var cssStyles = [styles.euiHeaderSection, grow && styles.grow, side && styles[side]];
  var classes = classNames('euiHeaderSection', className);
  return ___EmotionJSX("div", _extends({
    className: classes,
    css: cssStyles
  }, rest), children);
};