import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { euiHeaderSectionItemStyles } from './header_section_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Header items are small icon links that pop up menus
 */
export var EuiHeaderSectionItem = function EuiHeaderSectionItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = useEuiTheme();
  var styles = euiHeaderSectionItemStyles(euiTheme);
  var classes = classNames('euiHeaderSectionItem', className);

  // we check if there is any children and if not, we don't render anything
  return children ? ___EmotionJSX("div", _extends({
    className: classes,
    css: styles.euiHeaderSectionItem
  }, rest), children) : null;
};