import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "search", "strict", "highlightAll", "hasScreenReaderHelpText"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import { EuiMark } from '../mark';
import { HighlightAll } from './_highlight_all';
import { HighlightFirst } from './_highlight_first';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiHighlight = function EuiHighlight(_ref) {
  var children = _ref.children,
    className = _ref.className,
    search = _ref.search,
    _ref$strict = _ref.strict,
    strict = _ref$strict === void 0 ? false : _ref$strict,
    _ref$highlightAll = _ref.highlightAll,
    highlightAll = _ref$highlightAll === void 0 ? false : _ref$highlightAll,
    _ref$hasScreenReaderH = _ref.hasScreenReaderHelpText,
    hasScreenReaderHelpText = _ref$hasScreenReaderH === void 0 ? true : _ref$hasScreenReaderH,
    rest = _objectWithoutProperties(_ref, _excluded);
  var hasSearch = search && search.length > 0;
  var HighlightComponent = useMemo(function () {
    var Component = function Component(_ref2) {
      var children = _ref2.children;
      return ___EmotionJSX(EuiMark, {
        hasScreenReaderHelpText: hasScreenReaderHelpText
      }, children);
    };
    Component.displayName = '_HighlightComponent';
    return Component;
  }, [hasScreenReaderHelpText]);
  return ___EmotionJSX("span", _extends({
    className: className
  }, rest), children && hasSearch ? highlightAll ? ___EmotionJSX(HighlightAll, {
    searchValue: search,
    searchSubject: children,
    isStrict: strict,
    highlightComponent: HighlightComponent
  }) : ___EmotionJSX(HighlightFirst, {
    searchValue: search,
    searchSubject: children,
    isStrict: strict,
    highlightComponent: HighlightComponent
  }) : children);
};