import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["type", "size", "color", "className", "tabIndex", "title", "onIconLoad", "style", "stylesMemoizer"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { PureComponent } from 'react';
import classNames from 'classnames';
import { keysOf } from '../common';
import { typeToPathMap } from './icon_map';
import { icon as empty } from './assets/empty';
import { enqueueStateChange } from '../../services/react';
import { htmlIdGenerator, withEuiStylesMemoizer } from '../../services';
export { COLORS } from './named_colors';
import { isNamedColor } from './named_colors';
import { euiIconStyles } from './icon.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var getIsAppIcon = function getIsAppIcon(iconType) {
  if (typeof iconType !== 'string') return false;
  if (iconType === 'dataVisualizer') return true; // Special case
  if (iconType.indexOf('data:') === 0) return false; // Inline data URIs should be short-circuited for performance
  return iconType.endsWith('App') || iconType.endsWith('Job');
};
export var TYPES = keysOf(typeToPathMap);

// We accept arbitrary color strings, which are impossible to type.

export var SIZES = ['original', 's', 'm', 'l', 'xl', 'xxl'];
function isEuiIconType(x) {
  return typeof x === 'string' && typeToPathMap.hasOwnProperty(x);
}
function getInitialIcon(icon) {
  if (icon == null) {
    return undefined;
  }
  if (isEuiIconType(icon)) {
    if (iconComponentCache.hasOwnProperty(icon)) {
      return iconComponentCache[icon];
    }
    return undefined;
  }
  return icon;
}
var generateId = htmlIdGenerator();
var iconComponentCache = {};
export var clearIconComponentCache = function clearIconComponentCache(iconType) {
  if (iconType != null) {
    delete iconComponentCache[iconType];
  } else {
    iconComponentCache = {};
  }
};
export var appendIconComponentCache = function appendIconComponentCache(iconTypeToIconComponentMap) {
  for (var iconType in iconTypeToIconComponentMap) {
    if (iconTypeToIconComponentMap.hasOwnProperty(iconType)) {
      iconComponentCache[iconType] = iconTypeToIconComponentMap[iconType];
    }
  }
};
export var EuiIconClass = /*#__PURE__*/function (_PureComponent) {
  function EuiIconClass(props) {
    var _this;
    _classCallCheck(this, EuiIconClass);
    _this = _callSuper(this, EuiIconClass, [props]);
    _defineProperty(_this, "isMounted", false);
    _defineProperty(_this, "loadIconComponent", function (iconType) {
      if (iconComponentCache.hasOwnProperty(iconType)) {
        // exists in cache
        _this.setState({
          isLoading: false,
          neededLoading: false,
          icon: iconComponentCache[iconType]
        });
        _this.onIconLoad();
        return;
      }
      import( /* webpackChunkName: "icon.[request]" */
      // It's important that we don't use a template string here, it
      // stops webpack from building a dynamic require context.
      // eslint-disable-next-line prefer-template
      './assets/' + typeToPathMap[iconType]).then(function (_ref) {
        var icon = _ref.icon;
        iconComponentCache[iconType] = icon;
        enqueueStateChange(function () {
          if (_this.isMounted && _this.props.type === iconType) {
            _this.setState({
              icon: icon,
              iconTitle: iconType,
              isLoading: false
            }, _this.onIconLoad);
          }
        });
      });
    });
    _defineProperty(_this, "onIconLoad", function () {
      var onIconLoad = _this.props.onIconLoad;
      if (onIconLoad) {
        onIconLoad();
      }
    });
    var type = props.type;
    var initialIcon = getInitialIcon(type);
    _this.state = {
      icon: initialIcon,
      iconTitle: undefined,
      isLoading: false,
      neededLoading: false
    };
    return _this;
  }
  _inherits(EuiIconClass, _PureComponent);
  return _createClass(EuiIconClass, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.isMounted = true;
      var type = this.props.type;
      if (isEuiIconType(type) && this.state.icon == null) {
        this.setState({
          neededLoading: true,
          isLoading: true
        });
        this.loadIconComponent(type);
      } else {
        this.onIconLoad();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var type = this.props.type;
      if (type !== prevProps.type) {
        if (isEuiIconType(type)) {
          this.setState({
            neededLoading: iconComponentCache.hasOwnProperty(type),
            isLoading: true
          });
          this.loadIconComponent(type);
        } else {
          this.setState({
            icon: type,
            neededLoading: true,
            isLoading: false
          });
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.isMounted = false;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        type = _this$props.type,
        _this$props$size = _this$props.size,
        size = _this$props$size === void 0 ? 'm' : _this$props$size,
        color = _this$props.color,
        className = _this$props.className,
        tabIndex = _this$props.tabIndex,
        title = _this$props.title,
        onIconLoad = _this$props.onIconLoad,
        style = _this$props.style,
        stylesMemoizer = _this$props.stylesMemoizer,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var _this$state = this.state,
        isLoading = _this$state.isLoading,
        neededLoading = _this$state.neededLoading,
        iconTitle = _this$state.iconTitle;
      var isLoaded = !isLoading && neededLoading;
      var isCustomColor = color && !isNamedColor(color);
      var optionalCustomStyles = isCustomColor ? _objectSpread({
        color: color
      }, style) : style;

      // These icons are a little special and get some extra CSS flexibility
      var isAppIcon = getIsAppIcon(type);
      // App color styles are only applied if no color is passed or if color="default" is passed
      var appIconHasColor = color && color !== 'default';

      // The Elastic logo should be an outline in text and ghost mode
      var isElasticLogoOutline = type === 'logoElastic' && (color === 'ghost' || color === 'text');
      var classes = classNames('euiIcon', className);

      // Emotion styles
      var styles = stylesMemoizer(euiIconStyles);
      var cssStyles = [styles.euiIcon, styles[size], color && isNamedColor(color) && styles[color], isCustomColor && styles.customColor, isElasticLogoOutline && styles.logoElasticOutline, isAppIcon && !appIconHasColor && styles.app, isLoading && styles.isLoading, !isLoading && neededLoading && styles.isLoaded];
      var icon = this.state.icon || empty;
      if (typeof icon === 'string') {
        return ___EmotionJSX("img", _extends({
          alt: title ? title : '',
          src: icon,
          className: classes,
          css: cssStyles,
          style: style,
          tabIndex: tabIndex
        }, rest));
      } else {
        var Svg = icon;

        // If there is no aria-label, aria-labelledby, or title it gets aria-hidden true
        var isAriaHidden = !(this.props['aria-label'] || this.props['aria-labelledby'] || this.props.title);

        // If no aria-label or aria-labelledby is provided but there's a title, a titleId is generated
        //  The svg aria-labelledby attribute gets this titleId
        //  The svg title element gets this titleId as an id
        var titleId = !this.props['aria-label'] && !this.props['aria-labelledby'] && title ? {
          titleId: generateId()
        } : undefined;
        return ___EmotionJSX(Svg, _extends({
          className: classes,
          style: optionalCustomStyles,
          css: cssStyles,
          tabIndex: tabIndex,
          role: "img",
          title: title
        }, titleId, {
          "data-icon-type": iconTitle,
          "data-is-loaded": isLoaded || undefined,
          "data-is-loading": isLoading || undefined
        }, rest, {
          "aria-hidden": isAriaHidden || rest['aria-hidden']
        }));
      }
    }
  }]);
}(PureComponent);
export var EuiIcon = withEuiStylesMemoizer(EuiIconClass);