import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "alt", "url", "src", "size", "hasShadow", "style", "wrapperProps", "fullScreenIconColor", "allowFullScreen", "caption", "float", "margin", "onFullScreen"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState } from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { EuiImageWrapper } from './image_wrapper';
import { euiImageStyles } from './image.styles';
import { EuiImageFullScreenWrapper } from './image_fullscreen_wrapper';
import { SIZES } from './image_types';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiImage = function EuiImage(_ref) {
  var className = _ref.className,
    alt = _ref.alt,
    url = _ref.url,
    src = _ref.src,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'original' : _ref$size,
    hasShadow = _ref.hasShadow,
    style = _ref.style,
    wrapperProps = _ref.wrapperProps,
    fullScreenIconColor = _ref.fullScreenIconColor,
    allowFullScreen = _ref.allowFullScreen,
    caption = _ref.caption,
    float = _ref.float,
    margin = _ref.margin,
    onFullScreen = _ref.onFullScreen,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isFullScreen = _useState2[0],
    setIsFullScreen = _useState2[1];
  var isNamedSize = typeof size === 'string' && SIZES.includes(size);
  var classes = classNames('euiImage', className);
  var euiTheme = useEuiTheme();
  var styles = euiImageStyles(euiTheme);
  var cssStyles = [styles.euiImage, isNamedSize && styles[size], !isNamedSize && styles.customSize, hasShadow && styles.hasShadow];
  var cssIsFullScreenStyles = [styles.euiImage, styles.isFullScreen];
  var isCustomSize = !isNamedSize && size !== 'original';
  var customSize = typeof size === 'string' ? size : "".concat(size, "px");
  var imageStyleWithCustomSize = isCustomSize ? _objectSpread(_objectSpread({}, style), {}, {
    maxWidth: customSize,
    maxHeight: customSize
  }) : style;
  var isFullWidth = size === 'fullWidth';
  var commonWrapperProps = {
    hasShadow: hasShadow,
    wrapperProps: wrapperProps,
    setIsFullScreen: setIsFullScreen,
    fullScreenIconColor: fullScreenIconColor,
    isFullWidth: isFullWidth,
    allowFullScreen: allowFullScreen,
    alt: alt,
    caption: caption,
    float: float,
    margin: margin,
    onFullScreen: onFullScreen
  };
  var commonImgProps = _objectSpread({
    className: classes,
    src: src || url
  }, rest);
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiImageWrapper, commonWrapperProps, ___EmotionJSX("img", _extends({
    alt: alt,
    css: cssStyles,
    style: imageStyleWithCustomSize
  }, commonImgProps))), allowFullScreen && isFullScreen && ___EmotionJSX(EuiImageFullScreenWrapper, commonWrapperProps, ___EmotionJSX("img", _extends({
    alt: alt,
    css: cssIsFullScreenStyles,
    style: style
  }, commonImgProps))));
};