/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
import { euiShadow } from '../../themes/amsterdam/global_styling/mixins';
export var euiImageStyles = function euiImageStyles(euiThemeContext) {
  return {
    euiImage: /*#__PURE__*/css("vertical-align:middle;", logicalCSS('max-width', '100%'), " &,[class*='euiText'] &{", logicalCSS('margin-bottom', 0), ";};label:euiImage;"),
    // Variations
    isFullScreen: /*#__PURE__*/css("position:relative;", logicalCSS('max-height', '80vh'), " ", logicalCSS('max-width', '80vw'), ";;label:isFullScreen;"),
    hasShadow: /*#__PURE__*/css(euiShadow(euiThemeContext, 's'), ";;label:hasShadow;"),
    // Sizes
    // These sizes are mostly suggestions. Don't look too hard for meaning in their values.
    // Size is applied to the image, rather than the wrapper figure to work better with floats
    s: /*#__PURE__*/css(logicalCSS('width', '100px'), ";;label:s;"),
    m: /*#__PURE__*/css(logicalCSS('width', '200px'), ";;label:m;"),
    l: /*#__PURE__*/css(logicalCSS('width', '360px'), ";;label:l;"),
    xl: /*#__PURE__*/css(logicalCSS('width', '600px'), ";;label:xl;"),
    original: /*#__PURE__*/css(logicalCSS('width', 'auto'), ";;label:original;"),
    fullWidth: /*#__PURE__*/css(logicalCSS('width', '100%'), ";;label:fullWidth;"),
    customSize: /*#__PURE__*/css(logicalCSS('width', 'auto'), ";;label:customSize;")
  };
};