import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { EuiFocusTrap } from '../focus_trap';
import { EuiOverlayMask } from '../overlay_mask';
import { EuiIcon } from '../icon';
import { useEuiTheme, keys } from '../../services';
import { useInnerText } from '../inner_text';
import { euiImageFullscreenWrapperStyles } from './image_fullscreen_wrapper.styles';
import { EuiImageButton } from './image_button';
import { euiImageButtonIconStyles } from './image_button.styles';
import { EuiImageCaption } from './image_caption';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiImageFullScreenWrapper = function EuiImageFullScreenWrapper(_ref) {
  var alt = _ref.alt,
    hasShadow = _ref.hasShadow,
    caption = _ref.caption,
    children = _ref.children,
    setIsFullScreen = _ref.setIsFullScreen,
    wrapperProps = _ref.wrapperProps,
    isFullWidth = _ref.isFullWidth,
    fullScreenIconColor = _ref.fullScreenIconColor,
    onFullScreen = _ref.onFullScreen;
  var euiTheme = useEuiTheme();
  var styles = euiImageFullscreenWrapperStyles(euiTheme);
  var cssStyles = [styles.euiImageFullscreenWrapper, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.css];
  var classes = classNames('euiImageFullScreenWrapper', wrapperProps && wrapperProps.className);
  var onKeyDown = function onKeyDown(event) {
    if (event.key === keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      closeFullScreen();
    }
  };
  var closeFullScreen = function closeFullScreen() {
    setIsFullScreen(false);
    onFullScreen === null || onFullScreen === void 0 || onFullScreen(false);
  };
  var _useInnerText = useInnerText(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    optionalCaptionRef = _useInnerText2[0],
    optionalCaptionText = _useInnerText2[1];
  var iconStyles = euiImageButtonIconStyles(euiTheme);
  var cssIconStyles = [iconStyles.euiImageButton__icon, iconStyles.closeFullScreen];
  return ___EmotionJSX(EuiOverlayMask, {
    "data-test-subj": "fullScreenOverlayMask"
  }, ___EmotionJSX(EuiFocusTrap, {
    scrollLock: true,
    preventScrollOnFocus: true,
    onClickOutside: closeFullScreen
  }, ___EmotionJSX(React.Fragment, null, ___EmotionJSX("figure", _extends({
    "aria-label": optionalCaptionText
  }, wrapperProps, {
    className: classes,
    css: cssStyles
  }), ___EmotionJSX(EuiImageButton, {
    hasAlt: !!alt,
    hasShadow: hasShadow,
    onClick: closeFullScreen,
    onKeyDown: onKeyDown,
    "data-test-subj": "deactivateFullScreenButton",
    isFullScreen: true,
    isFullWidth: isFullWidth,
    fullScreenIconColor: fullScreenIconColor
  }, children), ___EmotionJSX(EuiImageCaption, {
    caption: caption,
    ref: optionalCaptionRef,
    isOnOverlayMask: true
  })), ___EmotionJSX(EuiIcon, {
    type: "fullScreenExit",
    color: "ghost",
    css: cssIconStyles
  }))));
};