import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { useInnerText } from '../inner_text';
import { euiImageWrapperStyles } from './image_wrapper.styles';
import { EuiImageButton } from './image_button';
import { EuiImageCaption } from './image_caption';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiImageWrapper = function EuiImageWrapper(_ref) {
  var alt = _ref.alt,
    caption = _ref.caption,
    hasShadow = _ref.hasShadow,
    allowFullScreen = _ref.allowFullScreen,
    float = _ref.float,
    margin = _ref.margin,
    children = _ref.children,
    setIsFullScreen = _ref.setIsFullScreen,
    wrapperProps = _ref.wrapperProps,
    fullScreenIconColor = _ref.fullScreenIconColor,
    isFullWidth = _ref.isFullWidth,
    onFullScreen = _ref.onFullScreen;
  var openFullScreen = function openFullScreen() {
    setIsFullScreen(true);
    onFullScreen === null || onFullScreen === void 0 || onFullScreen(true);
  };
  var classes = classNames('euiImageWrapper', wrapperProps && wrapperProps.className);
  var euiTheme = useEuiTheme();
  var styles = euiImageWrapperStyles(euiTheme);
  var cssFigureStyles = [styles.euiImageWrapper, float && styles[float], margin && styles[margin], allowFullScreen && styles.allowFullScreen, isFullWidth && styles.fullWidth, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.css];
  var _useInnerText = useInnerText(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    optionalCaptionRef = _useInnerText2[0],
    optionalCaptionText = _useInnerText2[1];
  return ___EmotionJSX("figure", _extends({
    "aria-label": optionalCaptionText
  }, wrapperProps, {
    className: classes,
    css: cssFigureStyles
  }), allowFullScreen ? ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiImageButton, {
    hasAlt: !!alt,
    hasShadow: hasShadow,
    onClick: openFullScreen,
    "data-test-subj": "activateFullScreenButton",
    isFullWidth: isFullWidth,
    fullScreenIconColor: fullScreenIconColor
  }, children)) : children, ___EmotionJSX(EuiImageCaption, {
    ref: optionalCaptionRef,
    caption: caption
  }));
};