import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "size", "readModeProps", "isReadOnly"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiText } from '../text';
import { EuiInlineEditForm, SMALL_SIZE_FORM, MEDIUM_SIZE_FORM } from './inline_edit_form';
import { euiInlineEditTextStyles } from './inline_edit_text.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiInlineEditText = function EuiInlineEditText(_ref) {
  var className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _readModeProps = _ref.readModeProps,
    isReadOnly = _ref.isReadOnly,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiInlineEditText', className);
  var styles = useEuiMemoizedStyles(euiInlineEditTextStyles);
  var cssStyles = [styles.euiInlineEditText, styles.fontSize[size]];
  var isSmallSize = ['xs', 's'].includes(size);
  var sizes = isSmallSize ? SMALL_SIZE_FORM : MEDIUM_SIZE_FORM;
  var readModeProps = useMemo(function () {
    if (!isReadOnly) return _readModeProps;
    return _objectSpread(_objectSpread({}, _readModeProps), {}, {
      role: 'paragraph'
    });
  }, [_readModeProps, isReadOnly]);
  return ___EmotionJSX(EuiInlineEditForm, _extends({
    className: classes,
    css: cssStyles,
    readModeProps: readModeProps,
    isReadOnly: isReadOnly,
    sizes: sizes
  }, rest), function (textReadModeValue) {
    return ___EmotionJSX(EuiText, {
      size: size,
      className: "eui-textTruncate"
    }, textReadModeValue);
  });
};