import _extends from "@babel/runtime/helpers/extends";
import _typeof from "@babel/runtime/helpers/typeof";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "checkable"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiFormLabel } from '../form/form_label/form_label';
import { euiKeyPadMenuStyles } from './key_pad_menu.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiKeyPadMenu = function EuiKeyPadMenu(_ref) {
  var _checkable$legendProp;
  var children = _ref.children,
    className = _ref.className,
    checkable = _ref.checkable,
    rest = _objectWithoutProperties(_ref, _excluded);
  var hasCheckableConfig = _typeof(checkable) === 'object';
  var classes = classNames('euiKeyPadMenu', className);
  var styles = useEuiMemoizedStyles(euiKeyPadMenuStyles);
  var cssStyles = [styles.euiKeyPadMenu];
  var legendCssStyles = [styles.euiKeyPadMenu__legend, hasCheckableConfig && (checkable === null || checkable === void 0 || (_checkable$legendProp = checkable.legendProps) === null || _checkable$legendProp === void 0 ? void 0 : _checkable$legendProp.css)];
  var legend = hasCheckableConfig && checkable.legend ? ___EmotionJSX(EuiFormLabel, _extends({}, checkable.legendProps, {
    css: legendCssStyles,
    type: "legend"
  }), checkable.legend) : undefined;
  return checkable ? ___EmotionJSX("fieldset", _extends({
    css: cssStyles,
    className: classes,
    "aria-label": hasCheckableConfig ? checkable.ariaLegend : undefined
  }, rest), legend, children) : ___EmotionJSX("ul", _extends({
    css: cssStyles,
    className: classes
  }, rest), React.Children.map(children, function (child) {
    return ___EmotionJSX("li", null, child);
  }));
};