/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits } from '../../global_styling';
export var euiKeyPadMenuVariables = function euiKeyPadMenuVariables(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiKeyPadMenuSize: mathWithUnits(euiTheme.size.base, function (x) {
      return x * 6;
    }),
    euiKeyPadMenuMarginSize: euiTheme.size.xs
  };
};
export var euiKeyPadMenuStyles = function euiKeyPadMenuStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiKeyPadMenuVariabl = euiKeyPadMenuVariables(euiThemeContext),
    euiKeyPadMenuSize = _euiKeyPadMenuVariabl.euiKeyPadMenuSize,
    euiKeyPadMenuMarginSize = _euiKeyPadMenuVariabl.euiKeyPadMenuMarginSize;
  return {
    euiKeyPadMenu: /*#__PURE__*/css("display:flex;flex-direction:row;flex-wrap:wrap;", logicalCSS('width', mathWithUnits([euiKeyPadMenuSize, euiKeyPadMenuMarginSize], function (x, y) {
      return x * 3 + y * 3;
    })), " ", logicalCSS('max-width', '100%'), " gap:", euiKeyPadMenuMarginSize, ";;label:euiKeyPadMenu;"),
    // Checkable = Fieldset and Legend
    euiKeyPadMenu__legend: /*#__PURE__*/css(logicalCSS('margin-bottom', euiTheme.size.s), ";;label:euiKeyPadMenu__legend;")
  };
};