import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["id", "isSelected", "isDisabled", "label", "children", "className", "betaBadgeLabel", "betaBadgeTooltipContent", "betaBadgeIconType", "betaBadgeTooltipProps", "href", "rel", "target", "buttonRef", "checkable", "name", "value", "disabled", "onChange"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles, getSecureRelForTarget, useGeneratedHtmlId } from '../../services';
import { EuiBetaBadge } from '../badge/beta_badge';
import { EuiRadio, EuiCheckbox } from '../form';
import { validateHref } from '../../services/security/href_validator';
import { EuiToolTip } from '../tool_tip';
import { euiKeyPadMenuItemStyles, euiKeyPadMenuItemChildStyles } from './key_pad_menu_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiKeyPadMenuItem = function EuiKeyPadMenuItem(_ref) {
  var id = _ref.id,
    isSelected = _ref.isSelected,
    _isDisabled = _ref.isDisabled,
    label = _ref.label,
    children = _ref.children,
    className = _ref.className,
    betaBadgeLabel = _ref.betaBadgeLabel,
    betaBadgeTooltipContent = _ref.betaBadgeTooltipContent,
    betaBadgeIconType = _ref.betaBadgeIconType,
    betaBadgeTooltipProps = _ref.betaBadgeTooltipProps,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    buttonRef = _ref.buttonRef,
    checkable = _ref.checkable,
    name = _ref.name,
    value = _ref.value,
    disabled = _ref.disabled,
    _onChange = _ref.onChange,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHrefValid = !href || validateHref(href);
  var isDisabled = disabled || _isDisabled || !isHrefValid;
  var styles = useEuiMemoizedStyles(euiKeyPadMenuItemStyles);
  var cssStyles = [styles.euiKeyPadMenuItem, !isDisabled ? styles.enabled : styles.disabled.disabled, isSelected && (!isDisabled ? styles.selected : styles.disabled.selected)];
  var classes = classNames('euiKeyPadMenuItem', className);
  var Element = href && !isDisabled ? 'a' : 'button';
  if (checkable) Element = 'label';
  var itemId = useGeneratedHtmlId({
    conditionalId: id
  });
  var childStyles = useEuiMemoizedStyles(euiKeyPadMenuItemChildStyles);
  var checkableElement = useMemo(function () {
    if (!checkable) return;
    var cssStyles = [childStyles.euiKeyPadMenuItem__checkableInput, !isSelected && isDisabled && childStyles.hideCheckableInput, !isSelected && !isDisabled && childStyles.showCheckableInputOnInteraction];
    var sharedProps = {
      id: itemId,
      className: 'euiKeyPadMenuItem__checkableInput',
      css: cssStyles,
      checked: isSelected,
      disabled: isDisabled,
      name: name
    };
    if (checkable === 'single') {
      return ___EmotionJSX(EuiRadio, _extends({}, sharedProps, {
        value: value,
        onChange: function onChange() {
          return _onChange(itemId, value);
        }
      }));
    } else {
      return ___EmotionJSX(EuiCheckbox, _extends({}, sharedProps, {
        onChange: function onChange() {
          return _onChange(itemId);
        }
      }));
    }
  }, [checkable, isDisabled, isSelected, _onChange, value, name, itemId, childStyles]);
  var betaBadge = useMemo(function () {
    if (!betaBadgeLabel) return;
    return ___EmotionJSX(EuiBetaBadge
    // Since we move the tooltip contents to a wrapping EuiToolTip,
    // this badge is purely visual therefore we can safely hide it from screen readers
    , {
      "aria-hidden": "true",
      size: "s",
      color: "subdued",
      className: "euiKeyPadMenuItem__betaBadge",
      css: childStyles.euiKeyPadMenuItem__betaBadge,
      label: betaBadgeLabel.charAt(0),
      iconType: betaBadgeIconType
    });
  }, [betaBadgeLabel, betaBadgeIconType, childStyles]);
  var relObj = {};
  if (href && !isDisabled) {
    relObj.href = href;
    relObj.rel = getSecureRelForTarget({
      href: href,
      target: target,
      rel: rel
    });
    relObj.target = target;
    relObj['aria-current'] = isSelected ? isSelected : undefined;
  } else if (checkable) {
    relObj.htmlFor = itemId;
  } else {
    relObj.disabled = isDisabled;
    relObj.type = 'button';
    relObj['aria-pressed'] = isSelected;
  }
  var button = ___EmotionJSX(Element, _extends({
    className: classes,
    css: cssStyles
  }, relObj, rest, {
    // Unable to get past `LegacyRef` conflicts
    ref: buttonRef
  }), ___EmotionJSX("span", {
    className: "euiKeyPadMenuItem__inner",
    css: childStyles.euiKeyPadMenuItem__inner
  }, checkable ? checkableElement : betaBadge, ___EmotionJSX("span", {
    className: "euiKeyPadMenuItem__icon",
    css: childStyles.euiKeyPadMenuItem__icon
  }, children), ___EmotionJSX("span", {
    className: "euiKeyPadMenuItem__label",
    css: childStyles.euiKeyPadMenuItem__label
  }, label)));
  return betaBadgeLabel ? ___EmotionJSX(EuiToolTip, _extends({}, betaBadgeTooltipProps, {
    title: betaBadgeLabel,
    content: betaBadgeTooltipContent,
    delay: "long"
  }), button) : button;
};