import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["target", "external"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { useEuiMemoizedStyles } from '../../services';
import { logicalStyle } from '../../global_styling';
import { EuiIcon } from '../icon';
import { EuiI18n } from '../i18n';
import { EuiScreenReaderOnly } from '../accessibility';

/**
 * DRY util for indicating external links both via icon and to
 * screen readers. Used internally by at EuiLink and EuiListGroupItem
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
var iconStyle = function iconStyle(_ref) {
  var euiTheme = _ref.euiTheme;
  return logicalStyle('margin-left', euiTheme.size.xs);
};
export var EuiExternalLinkIcon = function EuiExternalLinkIcon(_ref2) {
  var target = _ref2.target,
    external = _ref2.external,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var iconCssStyle = useEuiMemoizedStyles(iconStyle);
  var showExternalLinkIcon = target === '_blank' && external !== false || external === true;
  return ___EmotionJSX(React.Fragment, null, showExternalLinkIcon && ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiIcon, _extends({
    css: iconCssStyle,
    size: "s",
    type: "popout",
    role: "presentation"
  }, rest)), target === '_blank' ? ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("span", null, ___EmotionJSX(EuiI18n, {
    token: "euiExternalLinkIcon.newTarget.screenReaderOnlyText",
    default: "(external, opens in a new tab or window)"
  }))) : ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("span", null, ___EmotionJSX(EuiI18n, {
    token: "euiExternalLinkIcon.externalTarget.screenReaderOnlyText",
    default: "(external)"
  }))))));
};