import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "color", "className", "href", "external", "target", "rel", "type", "onClick", "disabled"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef } from 'react';
import classNames from 'classnames';
import { getSecureRelForTarget, useEuiMemoizedStyles } from '../../services';
import { validateHref } from '../../services/security/href_validator';
import { EuiExternalLinkIcon } from './external_link_icon';
import { euiLinkStyles } from './link.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['primary', 'subdued', 'success', 'accent', 'danger', 'warning', 'text', 'ghost'];
var EuiLink = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var children = _ref.children,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    className = _ref.className,
    href = _ref.href,
    external = _ref.external,
    target = _ref.target,
    rel = _ref.rel,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    onClick = _ref.onClick,
    _disabled = _ref.disabled,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiLinkStyles);
  var cssStyles = [styles.euiLink];
  var isHrefValid = !href || validateHref(href);
  var disabled = _disabled || !isHrefValid;
  if (href === undefined || !isHrefValid) {
    var buttonProps = _objectSpread({
      className: classNames('euiLink', className),
      css: [cssStyles, disabled ? [styles.disabled] : styles[color]],
      type: type,
      onClick: onClick,
      disabled: disabled
    }, rest);
    return ___EmotionJSX("button", _extends({
      ref: ref
    }, buttonProps), children);
  }
  var secureRel = getSecureRelForTarget({
    href: href,
    target: target,
    rel: rel
  });
  var anchorProps = _objectSpread({
    className: classNames('euiLink', className),
    css: [cssStyles, styles[color]],
    href: href,
    target: target,
    rel: secureRel,
    onClick: onClick
  }, rest);
  return ___EmotionJSX("a", _extends({
    ref: ref
  }, anchorProps), children, ___EmotionJSX(EuiExternalLinkIcon, {
    external: external,
    target: target
  }));
});
EuiLink.displayName = 'EuiLink';
export { EuiLink };