import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "listItems", "style", "flush", "bordered", "gutterSize", "wrapText", "maxWidth", "showToolTips", "color", "size", "ariaLabelledby"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { EuiListGroupItem } from './list_group_item';
import { useEuiTheme, cloneElementWithCss } from '../../services';
import { logicalStyle } from '../../global_styling';
import { euiListGroupStyles } from './list_group.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var GUTTER_SIZES = ['none', 's', 'm'];
export var EuiListGroup = function EuiListGroup(_ref) {
  var children = _ref.children,
    className = _ref.className,
    listItems = _ref.listItems,
    style = _ref.style,
    _ref$flush = _ref.flush,
    flush = _ref$flush === void 0 ? false : _ref$flush,
    _ref$bordered = _ref.bordered,
    bordered = _ref$bordered === void 0 ? false : _ref$bordered,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 's' : _ref$gutterSize,
    _ref$wrapText = _ref.wrapText,
    wrapText = _ref$wrapText === void 0 ? false : _ref$wrapText,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? true : _ref$maxWidth,
    _ref$showToolTips = _ref.showToolTips,
    showToolTips = _ref$showToolTips === void 0 ? false : _ref$showToolTips,
    color = _ref.color,
    size = _ref.size,
    ariaLabelledby = _ref.ariaLabelledby,
    rest = _objectWithoutProperties(_ref, _excluded);
  var newStyle = style;
  if (maxWidth && maxWidth !== true) {
    newStyle = _objectSpread(_objectSpread({}, newStyle), logicalStyle('max-width', maxWidth));
  }
  var classes = classNames('euiListGroup', className);
  var euiTheme = useEuiTheme();
  var styles = euiListGroupStyles(euiTheme);
  var cssStyles = [styles.euiListGroup, styles[gutterSize], flush && styles.flush, bordered && styles.bordered, maxWidth === true && styles.maxWidthDefault];
  var childrenOrListItems = null;
  if (listItems) {
    childrenOrListItems = listItems.map(function (item, index) {
      return [___EmotionJSX(EuiListGroupItem, _extends({
        key: "title-".concat(index),
        showToolTip: showToolTips,
        wrapText: wrapText
        // we're passing the parent `color` and `size` down to the children
        // so that they can inherit it if they don't have one
        ,
        color: color,
        size: size
      }, item))];
    });
  } else {
    var showToolTipObj = showToolTips && {
      showToolTip: true
    };
    childrenOrListItems = React.Children.map(children, function (child) {
      if ( /*#__PURE__*/React.isValidElement(child)) {
        return cloneElementWithCss(child, _objectSpread(_objectSpread({
          // we're passing the parent `color` and `size` down to the children
          // so that they can inherit it if they don't have one
          color: color,
          size: size
        }, showToolTipObj), child.props));
      }
    });
  }
  return ___EmotionJSX("ul", _extends({
    className: classes,
    css: cssStyles,
    style: newStyle,
    "aria-labelledby": ariaLabelledby
  }, rest), childrenOrListItems);
};