import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["label", "isActive", "isDisabled", "href", "rel", "target", "external", "className", "css", "style", "iconType", "icon", "iconProps", "extraAction", "onClick", "size", "color", "showToolTip", "wrapText", "buttonRef", "toolTipText", "toolTipProps"],
  _excluded2 = ["iconType", "alwaysShow", "isDisabled"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Fragment } from 'react';
import classNames from 'classnames';
import { EuiIcon } from '../icon';
import { EuiToolTip } from '../tool_tip';
import { useInnerText } from '../inner_text';
import { EuiListGroupItemExtraAction } from './list_group_item_extra_action';
import { getSecureRelForTarget, useEuiTheme, cloneElementWithCss } from '../../services';
import { validateHref } from '../../services/security/href_validator';
import { EuiExternalLinkIcon } from '../link/external_link_icon';
import { euiListGroupItemStyles, euiListGroupItemIconStyles, euiListGroupItemInnerStyles, euiListGroupItemTooltipStyles, euiListGroupItemLabelStyles } from './list_group_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['xs', 's', 'm', 'l'];
export var COLORS = ['primary', 'text', 'subdued'];
export var EuiListGroupItem = function EuiListGroupItem(_ref) {
  var label = _ref.label,
    _ref$isActive = _ref.isActive,
    isActive = _ref$isActive === void 0 ? false : _ref$isActive,
    _ref$isDisabled = _ref.isDisabled,
    _isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    external = _ref.external,
    className = _ref.className,
    customCss = _ref.css,
    style = _ref.style,
    iconType = _ref.iconType,
    icon = _ref.icon,
    iconProps = _ref.iconProps,
    extraAction = _ref.extraAction,
    onClick = _ref.onClick,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'text' : _ref$color,
    _ref$showToolTip = _ref.showToolTip,
    showToolTip = _ref$showToolTip === void 0 ? false : _ref$showToolTip,
    wrapText = _ref.wrapText,
    buttonRef = _ref.buttonRef,
    toolTipText = _ref.toolTipText,
    toolTipProps = _ref.toolTipProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isClickable = !!(href || onClick);
  var isHrefValid = !href || validateHref(href);
  var isDisabled = _isDisabled || !isHrefValid;
  var euiTheme = useEuiTheme();
  var iconStyles = euiListGroupItemIconStyles(euiTheme);
  var cssIconStyles = [iconStyles.euiListGroupItem__icon, iconProps === null || iconProps === void 0 ? void 0 : iconProps.css];
  var iconNode;
  if (iconType) {
    iconNode = ___EmotionJSX(EuiIcon, _extends({
      color: "inherit" // forces the icon to inherit its parent color
    }, iconProps, {
      type: iconType,
      className: classNames('euiListGroupItem__icon', iconProps === null || iconProps === void 0 ? void 0 : iconProps.className),
      css: cssIconStyles
    }));
    if (icon) {
      console.warn('Both `iconType` and `icon` were passed to EuiListGroupItem but only one can exist. The `iconType` was used.');
    }
  } else if (icon) {
    iconNode = cloneElementWithCss(icon, {
      css: cssIconStyles,
      className: classNames('euiListGroupItem__icon', icon.props.className)
    });
  }
  var extraActionNode;
  if (extraAction) {
    var _iconType = extraAction.iconType,
      alwaysShow = extraAction.alwaysShow,
      actionIsDisabled = extraAction.isDisabled,
      _rest = _objectWithoutProperties(extraAction, _excluded2);

    // EuiListGroupItemExtraActionProps extends EuiButtonIconPropsForButton
    // which doesn't have the color `subdued` so we need to assign a valid color
    // the most similar is `text` so we'll use that
    var extraActionColor = color === 'subdued' ? 'text' : color;
    extraActionNode = ___EmotionJSX(EuiListGroupItemExtraAction, _extends({
      color: extraActionColor,
      iconType: _iconType,
      alwaysShow: alwaysShow
    }, _rest, {
      isDisabled: actionIsDisabled,
      parentIsDisabled: isDisabled
    }));
  }
  var labelStyles = euiListGroupItemLabelStyles();
  var cssLabelStyles = [labelStyles.euiListGroupItem__label, wrapText ? labelStyles.wrapText : labelStyles.truncate];

  // Only add the label as the title attribute if it's possibly truncated
  // Also ensure the value of the title attribute is a string
  var _useInnerText = useInnerText(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    ref = _useInnerText2[0],
    innerText = _useInnerText2[1];
  var shouldRenderTitle = !wrapText && !showToolTip;
  var labelContent = shouldRenderTitle ? ___EmotionJSX("span", {
    ref: ref,
    className: "euiListGroupItem__label",
    css: cssLabelStyles,
    title: typeof label === 'string' ? label : innerText
  }, label) : ___EmotionJSX("span", {
    className: "euiListGroupItem__label",
    css: cssLabelStyles
  }, label);

  // Handle the variety of interaction behavior
  var itemContent;
  var innerStyles = euiListGroupItemInnerStyles(euiTheme);
  var cssInnerStyles = [innerStyles.euiListGroupItem__inner, innerStyles[size], !isDisabled && innerStyles[color], isActive && innerStyles.isActive, isDisabled && innerStyles.isDisabled, isClickable && !isDisabled && innerStyles.isClickable];
  if (href && !isDisabled) {
    itemContent = ___EmotionJSX("a", _extends({
      className: "euiListGroupItem__button",
      css: cssInnerStyles,
      href: href,
      target: target,
      rel: getSecureRelForTarget({
        href: href,
        rel: rel,
        target: target
      }),
      onClick: onClick
    }, rest), iconNode, labelContent, ___EmotionJSX(EuiExternalLinkIcon, {
      external: external,
      target: target
    }));
  } else if (href && isDisabled || onClick) {
    itemContent = ___EmotionJSX("button", _extends({
      type: "button",
      className: "euiListGroupItem__button",
      css: cssInnerStyles,
      disabled: isDisabled,
      onClick: onClick,
      ref: buttonRef
    }, rest), iconNode, labelContent);
  } else {
    itemContent = ___EmotionJSX("span", _extends({
      className: "euiListGroupItem__text",
      css: cssInnerStyles
    }, rest), iconNode, labelContent);
  }
  var styles = euiListGroupItemStyles(euiTheme);
  var cssStyles = [styles.euiListGroupItem, !isDisabled && isActive && styles.colors.isActive[color], !isDisabled && isClickable && styles.colors.isClickable[color], styles[size], customCss];
  var classes = classNames('euiListGroupItem', className);
  if (showToolTip) {
    var _toolTipProps$anchorP;
    var tooltipStyles = euiListGroupItemTooltipStyles();
    var cssTooltipStyles = [tooltipStyles.euiListGroupItem__tooltip, toolTipProps === null || toolTipProps === void 0 || (_toolTipProps$anchorP = toolTipProps.anchorProps) === null || _toolTipProps$anchorP === void 0 ? void 0 : _toolTipProps$anchorP.css];
    var anchorClasses = classNames('euiListGroupItem__tooltip', toolTipProps === null || toolTipProps === void 0 ? void 0 : toolTipProps.anchorClassName);
    var anchorPropsAndCss = _objectSpread(_objectSpread({}, toolTipProps === null || toolTipProps === void 0 ? void 0 : toolTipProps.anchorProps), {}, {
      css: cssTooltipStyles
    });
    itemContent = ___EmotionJSX("li", {
      className: classes,
      css: cssStyles,
      style: style
    }, ___EmotionJSX(EuiToolTip, _extends({
      content: toolTipText !== null && toolTipText !== void 0 ? toolTipText : label,
      position: "right",
      delay: "long"
    }, toolTipProps, {
      anchorClassName: anchorClasses,
      anchorProps: anchorPropsAndCss
    }), ___EmotionJSX(React.Fragment, null, itemContent, extraActionNode)));
  } else {
    itemContent = ___EmotionJSX("li", {
      className: classes,
      css: cssStyles,
      style: style
    }, itemContent, extraActionNode);
  }
  return ___EmotionJSX(Fragment, null, itemContent);
};