function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiCanAnimate, euiFontSize, logicalCSS, logicalShorthandCSS, euiBackgroundColor, euiTextTruncate, euiTextBreakWord } from '../../global_styling';
import { euiButtonColor } from '../../themes/amsterdam/global_styling/mixins/button';
export var euiListGroupItemStyles = function euiListGroupItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var primaryBgColor = euiBackgroundColor(euiThemeContext, 'primary', {
    method: 'transparent'
  });
  var subduedBgColor = euiBackgroundColor(euiThemeContext, 'subdued', {
    method: 'transparent'
  });
  return {
    // Base
    euiListGroupItem: /*#__PURE__*/css("padding:0;display:flex;align-items:center;position:relative;", euiCanAnimate, "{transition:background-color ", euiTheme.animation.fast, ";};label:euiListGroupItem;"),
    // Sizes
    xs: /*#__PURE__*/css("border-radius:", euiTheme.border.radius.small, ";;label:xs;"),
    s: /*#__PURE__*/css("border-radius:", euiTheme.border.radius.small, ";;label:s;"),
    m: /*#__PURE__*/css("border-radius:", euiTheme.border.radius.medium, ";;label:m;"),
    l: /*#__PURE__*/css("border-radius:", euiTheme.border.radius.medium, ";;label:l;"),
    // Colors
    colors: {
      isActive: {
        primary: /*#__PURE__*/css("background-color:", primaryBgColor, ";;label:primary;"),
        text: /*#__PURE__*/css("background-color:", subduedBgColor, ";;label:text;"),
        subdued: /*#__PURE__*/css("background-color:", subduedBgColor, ";;label:subdued;")
      },
      isClickable: {
        primary: /*#__PURE__*/css("&:hover,&:focus-within{background-color:", primaryBgColor, ";};label:primary;"),
        text: /*#__PURE__*/css("&:hover,&:focus-within{background-color:", subduedBgColor, ";};label:text;"),
        subdued: /*#__PURE__*/css("&:hover,&:focus-within{background-color:", subduedBgColor, ";};label:subdued;")
      }
    }
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1sre2yb-isClickable",
  styles: "&:hover,&:focus{text-decoration:underline;};label:isClickable;"
} : {
  name: "1sre2yb-isClickable",
  styles: "&:hover,&:focus{text-decoration:underline;};label:isClickable;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiListGroupItemInnerStyles = function euiListGroupItemInnerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiListGroupItem__inner: /*#__PURE__*/css(logicalShorthandCSS('padding', "".concat(euiTheme.size.xs, " ").concat(euiTheme.size.s)), " display:flex;align-items:center;flex-grow:1;max-inline-size:100%;overflow:hidden;text-align:start;font-weight:inherit;;label:euiListGroupItem__inner;"),
    // Sizes
    xs: /*#__PURE__*/css(euiFontSize(euiThemeContext, 'xs'), " font-weight:", euiTheme.font.weight.medium, ";letter-spacing:0;", logicalCSS('min-height', euiTheme.size.l), ";;label:xs;"),
    s: /*#__PURE__*/css(euiFontSize(euiThemeContext, 's'), " font-weight:", euiTheme.font.weight.medium, ";letter-spacing:0;", logicalCSS('min-height', euiTheme.size.xl), ";;label:s;"),
    m: /*#__PURE__*/css(euiFontSize(euiThemeContext, 'm'), " ", logicalCSS('min-height', euiTheme.size.xl), ";;label:m;"),
    l: /*#__PURE__*/css(euiFontSize(euiThemeContext, 'l'), " ", logicalCSS('min-height', euiTheme.size.xxl), ";;label:l;"),
    // Colors
    primary: /*#__PURE__*/css("color:", euiButtonColor(euiThemeContext, 'primary').color, ";;label:primary;"),
    text: /*#__PURE__*/css("color:", euiButtonColor(euiThemeContext, 'text').color, ";;label:text;"),
    subdued: /*#__PURE__*/css("color:", euiTheme.colors.subduedText, ";;label:subdued;"),
    ghost: /*#__PURE__*/css("color:", euiTheme.colors.ghost, ";;label:ghost;"),
    // Variants
    isDisabled: /*#__PURE__*/css("cursor:not-allowed;&,&:hover,&:focus{color:", euiButtonColor(euiThemeContext, 'disabled').color, ";cursor:not-allowed;background-color:transparent;text-decoration:none;};label:isDisabled;"),
    isActive: /*#__PURE__*/css(";label:isActive;"),
    isClickable: _ref,
    externalIcon: /*#__PURE__*/css(logicalCSS('margin-left', euiTheme.size.xs), ";;label:externalIcon;")
  };
};
export var euiListGroupItemLabelStyles = function euiListGroupItemLabelStyles() {
  return {
    // Base
    euiListGroupItem__label: /*#__PURE__*/css(";label:euiListGroupItem__label;"),
    truncate: /*#__PURE__*/css(euiTextTruncate(), ";;label:truncate;"),
    wrapText: /*#__PURE__*/css(euiTextBreakWord(), ";;label:wrapText;")
  };
};
export var euiListGroupItemIconStyles = function euiListGroupItemIconStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    // Base
    euiListGroupItem__icon: /*#__PURE__*/css(logicalCSS('margin-right', euiTheme.size.m), " flex-grow:0;flex-shrink:0;;label:euiListGroupItem__icon;")
  };
};
export var euiListGroupItemTooltipStyles = function euiListGroupItemTooltipStyles() {
  return {
    // Base
    euiListGroupItem__tooltip: /*#__PURE__*/css("display:inline-flex;", logicalCSS('width', '100%'), ";;label:euiListGroupItem__tooltip;")
  };
};